<?php

namespace Opsuite\Inventory;

class GetSpecialOffersForItemId
{

    /**
     * @var int $itemMasterId
     */
    protected $itemMasterId = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var boolean $showInactive
     */
    protected $showInactive = null;

    /**
     * @var ArrayOfint $ignoredPromoIds
     */
    protected $ignoredPromoIds = null;

    /**
     * @param int $itemMasterId
     * @param int $locationId
     * @param boolean $showInactive
     * @param ArrayOfint $ignoredPromoIds
     */
    public function __construct($itemMasterId, $locationId, $showInactive, $ignoredPromoIds)
    {
      $this->itemMasterId = $itemMasterId;
      $this->locationId = $locationId;
      $this->showInactive = $showInactive;
      $this->ignoredPromoIds = $ignoredPromoIds;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->itemMasterId;
    }

    /**
     * @param int $itemMasterId
     * @return \Opsuite\Inventory\GetSpecialOffersForItemId
     */
    public function setItemMasterId($itemMasterId)
    {
      $this->itemMasterId = $itemMasterId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\GetSpecialOffersForItemId
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getShowInactive()
    {
      return $this->showInactive;
    }

    /**
     * @param boolean $showInactive
     * @return \Opsuite\Inventory\GetSpecialOffersForItemId
     */
    public function setShowInactive($showInactive)
    {
      $this->showInactive = $showInactive;
      return $this;
    }

    /**
     * @return ArrayOfint
     */
    public function getIgnoredPromoIds()
    {
      return $this->ignoredPromoIds;
    }

    /**
     * @param ArrayOfint $ignoredPromoIds
     * @return \Opsuite\Inventory\GetSpecialOffersForItemId
     */
    public function setIgnoredPromoIds($ignoredPromoIds)
    {
      $this->ignoredPromoIds = $ignoredPromoIds;
      return $this;
    }

}
