<?php

namespace Opsuite\Inventory;

class GetQuantityOfItemsAtLocation
{

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var \DateTime $updatedAfterDateTime
     */
    protected $updatedAfterDateTime = null;

    /**
     * @param int $locationId
     * @param \DateTime $updatedAfterDateTime
     */
    public function __construct($locationId, \DateTime $updatedAfterDateTime)
    {
      $this->locationId = $locationId;
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\GetQuantityOfItemsAtLocation
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAfterDateTime()
    {
      if ($this->updatedAfterDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedAfterDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedAfterDateTime
     * @return \Opsuite\Inventory\GetQuantityOfItemsAtLocation
     */
    public function setUpdatedAfterDateTime(\DateTime $updatedAfterDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
