<?php

namespace Opsuite\Inventory;

class GetItemsWithSpecialOffersByLastUpdatedPaged
{

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var boolean $webItemsOnly
     */
    protected $webItemsOnly = null;

    /**
     * @var boolean $includeNotReady
     */
    protected $includeNotReady = null;

    /**
     * @var int $pageSize
     */
    protected $pageSize = null;

    /**
     * @var int $pageNumber
     */
    protected $pageNumber = null;

    /**
     * @var \DateTime $updatedAfterDateTime
     */
    protected $updatedAfterDateTime = null;

    /**
     * @var \DateTime $updatedBeforeDateTime
     */
    protected $updatedBeforeDateTime = null;

    /**
     * @param int $locationId
     * @param boolean $webItemsOnly
     * @param boolean $includeNotReady
     * @param int $pageSize
     * @param int $pageNumber
     * @param \DateTime $updatedAfterDateTime
     * @param \DateTime $updatedBeforeDateTime
     */
    public function __construct($locationId, $webItemsOnly, $includeNotReady, $pageSize, $pageNumber, \DateTime $updatedAfterDateTime, \DateTime $updatedBeforeDateTime)
    {
      $this->locationId = $locationId;
      $this->webItemsOnly = $webItemsOnly;
      $this->includeNotReady = $includeNotReady;
      $this->pageSize = $pageSize;
      $this->pageNumber = $pageNumber;
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      $this->updatedBeforeDateTime = $updatedBeforeDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getWebItemsOnly()
    {
      return $this->webItemsOnly;
    }

    /**
     * @param boolean $webItemsOnly
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setWebItemsOnly($webItemsOnly)
    {
      $this->webItemsOnly = $webItemsOnly;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeNotReady()
    {
      return $this->includeNotReady;
    }

    /**
     * @param boolean $includeNotReady
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setIncludeNotReady($includeNotReady)
    {
      $this->includeNotReady = $includeNotReady;
      return $this;
    }

    /**
     * @return int
     */
    public function getPageSize()
    {
      return $this->pageSize;
    }

    /**
     * @param int $pageSize
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setPageSize($pageSize)
    {
      $this->pageSize = $pageSize;
      return $this;
    }

    /**
     * @return int
     */
    public function getPageNumber()
    {
      return $this->pageNumber;
    }

    /**
     * @param int $pageNumber
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setPageNumber($pageNumber)
    {
      $this->pageNumber = $pageNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAfterDateTime()
    {
      if ($this->updatedAfterDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedAfterDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedAfterDateTime
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setUpdatedAfterDateTime(\DateTime $updatedAfterDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedBeforeDateTime()
    {
      if ($this->updatedBeforeDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedBeforeDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedBeforeDateTime
     * @return \Opsuite\Inventory\GetItemsWithSpecialOffersByLastUpdatedPaged
     */
    public function setUpdatedBeforeDateTime(\DateTime $updatedBeforeDateTime)
    {
      $this->updatedBeforeDateTime = $updatedBeforeDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
