<?php

namespace Opsuite\Inventory;

class GetItemsAtLocationPaged
{

    /**
     * @var int $pageNumber
     */
    protected $pageNumber = null;

    /**
     * @var int $locatonId
     */
    protected $locatonId = null;

    /**
     * @var \DateTime $updatedAfterDateTime
     */
    protected $updatedAfterDateTime = null;

    /**
     * @param int $pageNumber
     * @param int $locatonId
     * @param \DateTime $updatedAfterDateTime
     */
    public function __construct($pageNumber, $locatonId, \DateTime $updatedAfterDateTime)
    {
      $this->pageNumber = $pageNumber;
      $this->locatonId = $locatonId;
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return int
     */
    public function getPageNumber()
    {
      return $this->pageNumber;
    }

    /**
     * @param int $pageNumber
     * @return \Opsuite\Inventory\GetItemsAtLocationPaged
     */
    public function setPageNumber($pageNumber)
    {
      $this->pageNumber = $pageNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocatonId()
    {
      return $this->locatonId;
    }

    /**
     * @param int $locatonId
     * @return \Opsuite\Inventory\GetItemsAtLocationPaged
     */
    public function setLocatonId($locatonId)
    {
      $this->locatonId = $locatonId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAfterDateTime()
    {
      if ($this->updatedAfterDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedAfterDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedAfterDateTime
     * @return \Opsuite\Inventory\GetItemsAtLocationPaged
     */
    public function setUpdatedAfterDateTime(\DateTime $updatedAfterDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
