<?php

namespace Opsuite\Inventory;

class GetItemWebLinksBySku
{

    /**
     * @var string $sku
     */
    protected $sku = null;

    /**
     * @var int $urlType
     */
    protected $urlType = null;

    /**
     * @param string $sku
     * @param int $urlType
     */
    public function __construct($sku, $urlType)
    {
      $this->sku = $sku;
      $this->urlType = $urlType;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->sku;
    }

    /**
     * @param string $sku
     * @return \Opsuite\Inventory\GetItemWebLinksBySku
     */
    public function setSku($sku)
    {
      $this->sku = $sku;
      return $this;
    }

    /**
     * @return int
     */
    public function getUrlType()
    {
      return $this->urlType;
    }

    /**
     * @param int $urlType
     * @return \Opsuite\Inventory\GetItemWebLinksBySku
     */
    public function setUrlType($urlType)
    {
      $this->urlType = $urlType;
      return $this;
    }

}
