<?php

namespace Opsuite\Inventory;

class GetItemMastersWithWebContentByLastUpdatedPaged
{

    /**
     * @var boolean $includeNotReady
     */
    protected $includeNotReady = null;

    /**
     * @var int $pageNumber
     */
    protected $pageNumber = null;

    /**
     * @var \DateTime $updatedAfterDateTime
     */
    protected $updatedAfterDateTime = null;

    /**
     * @var \DateTime $updatedBeforeDateTime
     */
    protected $updatedBeforeDateTime = null;

    /**
     * @param boolean $includeNotReady
     * @param int $pageNumber
     * @param \DateTime $updatedAfterDateTime
     * @param \DateTime $updatedBeforeDateTime
     */
    public function __construct($includeNotReady, $pageNumber, \DateTime $updatedAfterDateTime, \DateTime $updatedBeforeDateTime)
    {
      $this->includeNotReady = $includeNotReady;
      $this->pageNumber = $pageNumber;
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      $this->updatedBeforeDateTime = $updatedBeforeDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return boolean
     */
    public function getIncludeNotReady()
    {
      return $this->includeNotReady;
    }

    /**
     * @param boolean $includeNotReady
     * @return \Opsuite\Inventory\GetItemMastersWithWebContentByLastUpdatedPaged
     */
    public function setIncludeNotReady($includeNotReady)
    {
      $this->includeNotReady = $includeNotReady;
      return $this;
    }

    /**
     * @return int
     */
    public function getPageNumber()
    {
      return $this->pageNumber;
    }

    /**
     * @param int $pageNumber
     * @return \Opsuite\Inventory\GetItemMastersWithWebContentByLastUpdatedPaged
     */
    public function setPageNumber($pageNumber)
    {
      $this->pageNumber = $pageNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAfterDateTime()
    {
      if ($this->updatedAfterDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedAfterDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedAfterDateTime
     * @return \Opsuite\Inventory\GetItemMastersWithWebContentByLastUpdatedPaged
     */
    public function setUpdatedAfterDateTime(\DateTime $updatedAfterDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedBeforeDateTime()
    {
      if ($this->updatedBeforeDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedBeforeDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedBeforeDateTime
     * @return \Opsuite\Inventory\GetItemMastersWithWebContentByLastUpdatedPaged
     */
    public function setUpdatedBeforeDateTime(\DateTime $updatedBeforeDateTime)
    {
      $this->updatedBeforeDateTime = $updatedBeforeDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
