<?php

namespace Opsuite\Inventory;

class GetItemMastersByLastUpdated
{

    /**
     * @var \DateTime $updatedAfterDateTime
     */
    protected $updatedAfterDateTime = null;

    /**
     * @var \DateTime $updatedBeforeDateTime
     */
    protected $updatedBeforeDateTime = null;

    /**
     * @param \DateTime $updatedAfterDateTime
     * @param \DateTime $updatedBeforeDateTime
     */
    public function __construct(\DateTime $updatedAfterDateTime, \DateTime $updatedBeforeDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      $this->updatedBeforeDateTime = $updatedBeforeDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAfterDateTime()
    {
      if ($this->updatedAfterDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedAfterDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedAfterDateTime
     * @return \Opsuite\Inventory\GetItemMastersByLastUpdated
     */
    public function setUpdatedAfterDateTime(\DateTime $updatedAfterDateTime)
    {
      $this->updatedAfterDateTime = $updatedAfterDateTime->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedBeforeDateTime()
    {
      if ($this->updatedBeforeDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->updatedBeforeDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $updatedBeforeDateTime
     * @return \Opsuite\Inventory\GetItemMastersByLastUpdated
     */
    public function setUpdatedBeforeDateTime(\DateTime $updatedBeforeDateTime)
    {
      $this->updatedBeforeDateTime = $updatedBeforeDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
