<?php

namespace Opsuite\Inventory;

class GetDiscountCoupon
{

    /**
     * @var string $serialNumber
     */
    protected $serialNumber = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @param string $serialNumber
     * @param int $locationId
     */
    public function __construct($serialNumber, $locationId)
    {
      $this->serialNumber = $serialNumber;
      $this->locationId = $locationId;
    }

    /**
     * @return string
     */
    public function getSerialNumber()
    {
      return $this->serialNumber;
    }

    /**
     * @param string $serialNumber
     * @return \Opsuite\Inventory\GetDiscountCoupon
     */
    public function setSerialNumber($serialNumber)
    {
      $this->serialNumber = $serialNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\GetDiscountCoupon
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

}
