<?php

namespace Opsuite\Inventory;

class GetBounceBackVoucher
{

    /**
     * @var int $transactionNumber
     */
    protected $transactionNumber = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var int $askingLocationId
     */
    protected $askingLocationId = null;

    /**
     * @var int $couponNumber
     */
    protected $couponNumber = null;

    /**
     * @param int $transactionNumber
     * @param int $locationId
     * @param int $askingLocationId
     * @param int $couponNumber
     */
    public function __construct($transactionNumber, $locationId, $askingLocationId, $couponNumber)
    {
      $this->transactionNumber = $transactionNumber;
      $this->locationId = $locationId;
      $this->askingLocationId = $askingLocationId;
      $this->couponNumber = $couponNumber;
    }

    /**
     * @return int
     */
    public function getTransactionNumber()
    {
      return $this->transactionNumber;
    }

    /**
     * @param int $transactionNumber
     * @return \Opsuite\Inventory\GetBounceBackVoucher
     */
    public function setTransactionNumber($transactionNumber)
    {
      $this->transactionNumber = $transactionNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\GetBounceBackVoucher
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getAskingLocationId()
    {
      return $this->askingLocationId;
    }

    /**
     * @param int $askingLocationId
     * @return \Opsuite\Inventory\GetBounceBackVoucher
     */
    public function setAskingLocationId($askingLocationId)
    {
      $this->askingLocationId = $askingLocationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCouponNumber()
    {
      return $this->couponNumber;
    }

    /**
     * @param int $couponNumber
     * @return \Opsuite\Inventory\GetBounceBackVoucher
     */
    public function setCouponNumber($couponNumber)
    {
      $this->couponNumber = $couponNumber;
      return $this;
    }

}
