<?php

namespace Opsuite\Inventory;

class DoesItemHaveWebContentBySku
{

    /**
     * @var string $sku
     */
    protected $sku = null;

    /**
     * @var boolean $includeNotReady
     */
    protected $includeNotReady = null;

    /**
     * @param string $sku
     * @param boolean $includeNotReady
     */
    public function __construct($sku, $includeNotReady)
    {
      $this->sku = $sku;
      $this->includeNotReady = $includeNotReady;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->sku;
    }

    /**
     * @param string $sku
     * @return \Opsuite\Inventory\DoesItemHaveWebContentBySku
     */
    public function setSku($sku)
    {
      $this->sku = $sku;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeNotReady()
    {
      return $this->includeNotReady;
    }

    /**
     * @param boolean $includeNotReady
     * @return \Opsuite\Inventory\DoesItemHaveWebContentBySku
     */
    public function setIncludeNotReady($includeNotReady)
    {
      $this->includeNotReady = $includeNotReady;
      return $this;
    }

}
