<?php

namespace Opsuite\Inventory;

class CreateBounceBackVoucher
{

    /**
     * @var int $transactionNumber
     */
    protected $transactionNumber = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var int $couponNumber
     */
    protected $couponNumber = null;

    /**
     * @var \DateTime $issueDate
     */
    protected $issueDate = null;

    /**
     * @var \DateTime $expiryDate
     */
    protected $expiryDate = null;

    /**
     * @var string $promotionCode
     */
    protected $promotionCode = null;

    /**
     * @var int $itemId
     */
    protected $itemId = null;

    /**
     * @var int $customerId
     */
    protected $customerId = null;

    /**
     * @var int $cashierId
     */
    protected $cashierId = null;

    /**
     * @param int $transactionNumber
     * @param int $locationId
     * @param int $couponNumber
     * @param \DateTime $issueDate
     * @param \DateTime $expiryDate
     * @param string $promotionCode
     * @param int $itemId
     * @param int $customerId
     * @param int $cashierId
     */
    public function __construct($transactionNumber, $locationId, $couponNumber, \DateTime $issueDate, \DateTime $expiryDate, $promotionCode, $itemId, $customerId, $cashierId)
    {
      $this->transactionNumber = $transactionNumber;
      $this->locationId = $locationId;
      $this->couponNumber = $couponNumber;
      $this->issueDate = $issueDate->format(\DateTime::ATOM);
      $this->expiryDate = $expiryDate->format(\DateTime::ATOM);
      $this->promotionCode = $promotionCode;
      $this->itemId = $itemId;
      $this->customerId = $customerId;
      $this->cashierId = $cashierId;
    }

    /**
     * @return int
     */
    public function getTransactionNumber()
    {
      return $this->transactionNumber;
    }

    /**
     * @param int $transactionNumber
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setTransactionNumber($transactionNumber)
    {
      $this->transactionNumber = $transactionNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCouponNumber()
    {
      return $this->couponNumber;
    }

    /**
     * @param int $couponNumber
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setCouponNumber($couponNumber)
    {
      $this->couponNumber = $couponNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getIssueDate()
    {
      if ($this->issueDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->issueDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $issueDate
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setIssueDate(\DateTime $issueDate)
    {
      $this->issueDate = $issueDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpiryDate()
    {
      if ($this->expiryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->expiryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $expiryDate
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setExpiryDate(\DateTime $expiryDate)
    {
      $this->expiryDate = $expiryDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionCode()
    {
      return $this->promotionCode;
    }

    /**
     * @param string $promotionCode
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setPromotionCode($promotionCode)
    {
      $this->promotionCode = $promotionCode;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemId()
    {
      return $this->itemId;
    }

    /**
     * @param int $itemId
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setItemId($itemId)
    {
      $this->itemId = $itemId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->customerId;
    }

    /**
     * @param int $customerId
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setCustomerId($customerId)
    {
      $this->customerId = $customerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCashierId()
    {
      return $this->cashierId;
    }

    /**
     * @param int $cashierId
     * @return \Opsuite\Inventory\CreateBounceBackVoucher
     */
    public function setCashierId($cashierId)
    {
      $this->cashierId = $cashierId;
      return $this;
    }

}
