<?php

namespace Opsuite\Inventory;

class BounceBackVoucherDetail
{

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var \DateTime $ExpiryDate
     */
    protected $ExpiryDate = null;

    /**
     * @var int $IssueId
     */
    protected $IssueId = null;

    /**
     * @var int $ItemLocationDetailId
     */
    protected $ItemLocationDetailId = null;

    /**
     * @var int $NumberOfUses
     */
    protected $NumberOfUses = null;

    /**
     * @var string $PromotionCode
     */
    protected $PromotionCode = null;

    /**
     * @var \DateTime $RedeemedDate
     */
    protected $RedeemedDate = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpiryDate()
    {
      if ($this->ExpiryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ExpiryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ExpiryDate
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setExpiryDate(\DateTime $ExpiryDate = null)
    {
      if ($ExpiryDate == null) {
       $this->ExpiryDate = null;
      } else {
        $this->ExpiryDate = $ExpiryDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getIssueId()
    {
      return $this->IssueId;
    }

    /**
     * @param int $IssueId
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setIssueId($IssueId)
    {
      $this->IssueId = $IssueId;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemLocationDetailId()
    {
      return $this->ItemLocationDetailId;
    }

    /**
     * @param int $ItemLocationDetailId
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setItemLocationDetailId($ItemLocationDetailId)
    {
      $this->ItemLocationDetailId = $ItemLocationDetailId;
      return $this;
    }

    /**
     * @return int
     */
    public function getNumberOfUses()
    {
      return $this->NumberOfUses;
    }

    /**
     * @param int $NumberOfUses
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setNumberOfUses($NumberOfUses)
    {
      $this->NumberOfUses = $NumberOfUses;
      return $this;
    }

    /**
     * @return string
     */
    public function getPromotionCode()
    {
      return $this->PromotionCode;
    }

    /**
     * @param string $PromotionCode
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setPromotionCode($PromotionCode)
    {
      $this->PromotionCode = $PromotionCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getRedeemedDate()
    {
      if ($this->RedeemedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->RedeemedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $RedeemedDate
     * @return \Opsuite\Inventory\BounceBackVoucherDetail
     */
    public function setRedeemedDate(\DateTime $RedeemedDate = null)
    {
      if ($RedeemedDate == null) {
       $this->RedeemedDate = null;
      } else {
        $this->RedeemedDate = $RedeemedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

}
