<?php

namespace Opsuite\Inventory;

class ArrayOfWebLink implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var WebLink[] $WebLink
     */
    protected $WebLink = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return WebLink[]
     */
    public function getWebLink()
    {
      return $this->WebLink;
    }

    /**
     * @param WebLink[] $WebLink
     * @return \Opsuite\Inventory\ArrayOfWebLink
     */
    public function setWebLink(array $WebLink = null)
    {
      $this->WebLink = $WebLink;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->WebLink[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return WebLink
     */
    public function offsetGet($offset)
    {
      return $this->WebLink[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param WebLink $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->WebLink[] = $value;
      } else {
        $this->WebLink[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->WebLink[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return WebLink Return the current element
     */
    public function current()
    {
      return current($this->WebLink);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->WebLink);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->WebLink);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->WebLink);
    }

    /**
     * Countable implementation
     *
     * @return WebLink Return count of elements
     */
    public function count()
    {
      return count($this->WebLink);
    }

}
