<?php

namespace Opsuite\Inventory;

class ArrayOfVendor implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Vendor[] $Vendor
     */
    protected $Vendor = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Vendor[]
     */
    public function getVendor()
    {
      return $this->Vendor;
    }

    /**
     * @param Vendor[] $Vendor
     * @return \Opsuite\Inventory\ArrayOfVendor
     */
    public function setVendor(array $Vendor = null)
    {
      $this->Vendor = $Vendor;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Vendor[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Vendor
     */
    public function offsetGet($offset)
    {
      return $this->Vendor[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Vendor $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Vendor[] = $value;
      } else {
        $this->Vendor[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Vendor[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Vendor Return the current element
     */
    public function current()
    {
      return current($this->Vendor);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Vendor);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Vendor);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Vendor);
    }

    /**
     * Countable implementation
     *
     * @return Vendor Return count of elements
     */
    public function count()
    {
      return count($this->Vendor);
    }

}
