<?php

namespace Opsuite\Inventory;

class ArrayOfSpecialOffer implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SpecialOffer[] $SpecialOffer
     */
    protected $SpecialOffer = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SpecialOffer[]
     */
    public function getSpecialOffer()
    {
      return $this->SpecialOffer;
    }

    /**
     * @param SpecialOffer[] $SpecialOffer
     * @return \Opsuite\Inventory\ArrayOfSpecialOffer
     */
    public function setSpecialOffer(array $SpecialOffer = null)
    {
      $this->SpecialOffer = $SpecialOffer;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SpecialOffer[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SpecialOffer
     */
    public function offsetGet($offset)
    {
      return $this->SpecialOffer[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SpecialOffer $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SpecialOffer[] = $value;
      } else {
        $this->SpecialOffer[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SpecialOffer[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SpecialOffer Return the current element
     */
    public function current()
    {
      return current($this->SpecialOffer);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SpecialOffer);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SpecialOffer);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SpecialOffer);
    }

    /**
     * Countable implementation
     *
     * @return SpecialOffer Return count of elements
     */
    public function count()
    {
      return count($this->SpecialOffer);
    }

}
