<?php

namespace Opsuite\Inventory;

class ArrayOfProductPackage implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ProductPackage[] $ProductPackage
     */
    protected $ProductPackage = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ProductPackage[]
     */
    public function getProductPackage()
    {
      return $this->ProductPackage;
    }

    /**
     * @param ProductPackage[] $ProductPackage
     * @return \Opsuite\Inventory\ArrayOfProductPackage
     */
    public function setProductPackage(array $ProductPackage = null)
    {
      $this->ProductPackage = $ProductPackage;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ProductPackage[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ProductPackage
     */
    public function offsetGet($offset)
    {
      return $this->ProductPackage[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ProductPackage $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ProductPackage[] = $value;
      } else {
        $this->ProductPackage[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ProductPackage[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ProductPackage Return the current element
     */
    public function current()
    {
      return current($this->ProductPackage);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ProductPackage);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ProductPackage);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ProductPackage);
    }

    /**
     * Countable implementation
     *
     * @return ProductPackage Return count of elements
     */
    public function count()
    {
      return count($this->ProductPackage);
    }

}
