<?php

namespace Opsuite\Inventory;

class ArrayOfMatrixMaster implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var MatrixMaster[] $MatrixMaster
     */
    protected $MatrixMaster = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return MatrixMaster[]
     */
    public function getMatrixMaster()
    {
      return $this->MatrixMaster;
    }

    /**
     * @param MatrixMaster[] $MatrixMaster
     * @return \Opsuite\Inventory\ArrayOfMatrixMaster
     */
    public function setMatrixMaster(array $MatrixMaster = null)
    {
      $this->MatrixMaster = $MatrixMaster;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->MatrixMaster[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return MatrixMaster
     */
    public function offsetGet($offset)
    {
      return $this->MatrixMaster[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param MatrixMaster $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->MatrixMaster[] = $value;
      } else {
        $this->MatrixMaster[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->MatrixMaster[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return MatrixMaster Return the current element
     */
    public function current()
    {
      return current($this->MatrixMaster);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->MatrixMaster);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->MatrixMaster);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->MatrixMaster);
    }

    /**
     * Countable implementation
     *
     * @return MatrixMaster Return count of elements
     */
    public function count()
    {
      return count($this->MatrixMaster);
    }

}
