<?php

namespace Opsuite\Inventory;

class ArrayOfManualAdjustmentLine implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ManualAdjustmentLine[] $ManualAdjustmentLine
     */
    protected $ManualAdjustmentLine = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ManualAdjustmentLine[]
     */
    public function getManualAdjustmentLine()
    {
      return $this->ManualAdjustmentLine;
    }

    /**
     * @param ManualAdjustmentLine[] $ManualAdjustmentLine
     * @return \Opsuite\Inventory\ArrayOfManualAdjustmentLine
     */
    public function setManualAdjustmentLine(array $ManualAdjustmentLine = null)
    {
      $this->ManualAdjustmentLine = $ManualAdjustmentLine;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ManualAdjustmentLine[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ManualAdjustmentLine
     */
    public function offsetGet($offset)
    {
      return $this->ManualAdjustmentLine[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ManualAdjustmentLine $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ManualAdjustmentLine[] = $value;
      } else {
        $this->ManualAdjustmentLine[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ManualAdjustmentLine[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ManualAdjustmentLine Return the current element
     */
    public function current()
    {
      return current($this->ManualAdjustmentLine);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ManualAdjustmentLine);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ManualAdjustmentLine);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ManualAdjustmentLine);
    }

    /**
     * Countable implementation
     *
     * @return ManualAdjustmentLine Return count of elements
     */
    public function count()
    {
      return count($this->ManualAdjustmentLine);
    }

}
