<?php

namespace Opsuite\Inventory;

class ArrayOfManualAdjustmentDocument implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ManualAdjustmentDocument[] $ManualAdjustmentDocument
     */
    protected $ManualAdjustmentDocument = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ManualAdjustmentDocument[]
     */
    public function getManualAdjustmentDocument()
    {
      return $this->ManualAdjustmentDocument;
    }

    /**
     * @param ManualAdjustmentDocument[] $ManualAdjustmentDocument
     * @return \Opsuite\Inventory\ArrayOfManualAdjustmentDocument
     */
    public function setManualAdjustmentDocument(array $ManualAdjustmentDocument = null)
    {
      $this->ManualAdjustmentDocument = $ManualAdjustmentDocument;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ManualAdjustmentDocument[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ManualAdjustmentDocument
     */
    public function offsetGet($offset)
    {
      return $this->ManualAdjustmentDocument[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ManualAdjustmentDocument $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ManualAdjustmentDocument[] = $value;
      } else {
        $this->ManualAdjustmentDocument[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ManualAdjustmentDocument[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ManualAdjustmentDocument Return the current element
     */
    public function current()
    {
      return current($this->ManualAdjustmentDocument);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ManualAdjustmentDocument);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ManualAdjustmentDocument);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ManualAdjustmentDocument);
    }

    /**
     * Countable implementation
     *
     * @return ManualAdjustmentDocument Return count of elements
     */
    public function count()
    {
      return count($this->ManualAdjustmentDocument);
    }

}
