<?php

namespace Opsuite\Inventory;

class ArrayOfItemQuantity implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ItemQuantity[] $ItemQuantity
     */
    protected $ItemQuantity = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ItemQuantity[]
     */
    public function getItemQuantity()
    {
      return $this->ItemQuantity;
    }

    /**
     * @param ItemQuantity[] $ItemQuantity
     * @return \Opsuite\Inventory\ArrayOfItemQuantity
     */
    public function setItemQuantity(array $ItemQuantity = null)
    {
      $this->ItemQuantity = $ItemQuantity;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ItemQuantity[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ItemQuantity
     */
    public function offsetGet($offset)
    {
      return $this->ItemQuantity[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ItemQuantity $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ItemQuantity[] = $value;
      } else {
        $this->ItemQuantity[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ItemQuantity[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ItemQuantity Return the current element
     */
    public function current()
    {
      return current($this->ItemQuantity);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ItemQuantity);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ItemQuantity);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ItemQuantity);
    }

    /**
     * Countable implementation
     *
     * @return ItemQuantity Return count of elements
     */
    public function count()
    {
      return count($this->ItemQuantity);
    }

}
