<?php

namespace Opsuite\Inventory;

class ArrayOfItemMasterAttributes implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ItemMasterAttributes[] $ItemMasterAttributes
     */
    protected $ItemMasterAttributes = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ItemMasterAttributes[]
     */
    public function getItemMasterAttributes()
    {
      return $this->ItemMasterAttributes;
    }

    /**
     * @param ItemMasterAttributes[] $ItemMasterAttributes
     * @return \Opsuite\Inventory\ArrayOfItemMasterAttributes
     */
    public function setItemMasterAttributes(array $ItemMasterAttributes = null)
    {
      $this->ItemMasterAttributes = $ItemMasterAttributes;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ItemMasterAttributes[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ItemMasterAttributes
     */
    public function offsetGet($offset)
    {
      return $this->ItemMasterAttributes[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ItemMasterAttributes $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ItemMasterAttributes[] = $value;
      } else {
        $this->ItemMasterAttributes[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ItemMasterAttributes[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ItemMasterAttributes Return the current element
     */
    public function current()
    {
      return current($this->ItemMasterAttributes);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ItemMasterAttributes);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ItemMasterAttributes);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ItemMasterAttributes);
    }

    /**
     * Countable implementation
     *
     * @return ItemMasterAttributes Return count of elements
     */
    public function count()
    {
      return count($this->ItemMasterAttributes);
    }

}
