<?php

namespace Opsuite\Inventory;

class ArrayOfItemMaster implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ItemMaster[] $ItemMaster
     */
    protected $ItemMaster = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ItemMaster[]
     */
    public function getItemMaster()
    {
      return $this->ItemMaster;
    }

    /**
     * @param ItemMaster[] $ItemMaster
     * @return \Opsuite\Inventory\ArrayOfItemMaster
     */
    public function setItemMaster(array $ItemMaster = null)
    {
      $this->ItemMaster = $ItemMaster;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ItemMaster[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ItemMaster
     */
    public function offsetGet($offset)
    {
      return $this->ItemMaster[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ItemMaster $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ItemMaster[] = $value;
      } else {
        $this->ItemMaster[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ItemMaster[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ItemMaster Return the current element
     */
    public function current()
    {
      return current($this->ItemMaster);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ItemMaster);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ItemMaster);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ItemMaster);
    }

    /**
     * Countable implementation
     *
     * @return ItemMaster Return count of elements
     */
    public function count()
    {
      return count($this->ItemMaster);
    }

}
