<?php

namespace Opsuite\Inventory;

class ArrayOfInventoryAdjustment implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var InventoryAdjustment[] $InventoryAdjustment
     */
    protected $InventoryAdjustment = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return InventoryAdjustment[]
     */
    public function getInventoryAdjustment()
    {
      return $this->InventoryAdjustment;
    }

    /**
     * @param InventoryAdjustment[] $InventoryAdjustment
     * @return \Opsuite\Inventory\ArrayOfInventoryAdjustment
     */
    public function setInventoryAdjustment(array $InventoryAdjustment = null)
    {
      $this->InventoryAdjustment = $InventoryAdjustment;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->InventoryAdjustment[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return InventoryAdjustment
     */
    public function offsetGet($offset)
    {
      return $this->InventoryAdjustment[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param InventoryAdjustment $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->InventoryAdjustment[] = $value;
      } else {
        $this->InventoryAdjustment[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->InventoryAdjustment[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return InventoryAdjustment Return the current element
     */
    public function current()
    {
      return current($this->InventoryAdjustment);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->InventoryAdjustment);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->InventoryAdjustment);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->InventoryAdjustment);
    }

    /**
     * Countable implementation
     *
     * @return InventoryAdjustment Return count of elements
     */
    public function count()
    {
      return count($this->InventoryAdjustment);
    }

}
