<?php

namespace Opsuite\Inventory;

class ArrayOfCommunity implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Community[] $Community
     */
    protected $Community = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Community[]
     */
    public function getCommunity()
    {
      return $this->Community;
    }

    /**
     * @param Community[] $Community
     * @return \Opsuite\Inventory\ArrayOfCommunity
     */
    public function setCommunity(array $Community = null)
    {
      $this->Community = $Community;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Community[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Community
     */
    public function offsetGet($offset)
    {
      return $this->Community[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Community $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Community[] = $value;
      } else {
        $this->Community[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Community[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Community Return the current element
     */
    public function current()
    {
      return current($this->Community);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Community);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Community);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Community);
    }

    /**
     * Countable implementation
     *
     * @return Community Return count of elements
     */
    public function count()
    {
      return count($this->Community);
    }

}
