<?php

namespace Opsuite\Inventory;

class ArrayOfAttributePair implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AttributePair[] $AttributePair
     */
    protected $AttributePair = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AttributePair[]
     */
    public function getAttributePair()
    {
      return $this->AttributePair;
    }

    /**
     * @param AttributePair[] $AttributePair
     * @return \Opsuite\Inventory\ArrayOfAttributePair
     */
    public function setAttributePair(array $AttributePair = null)
    {
      $this->AttributePair = $AttributePair;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AttributePair[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AttributePair
     */
    public function offsetGet($offset)
    {
      return $this->AttributePair[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AttributePair $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AttributePair[] = $value;
      } else {
        $this->AttributePair[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AttributePair[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AttributePair Return the current element
     */
    public function current()
    {
      return current($this->AttributePair);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AttributePair);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AttributePair);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AttributePair);
    }

    /**
     * Countable implementation
     *
     * @return AttributePair Return count of elements
     */
    public function count()
    {
      return count($this->AttributePair);
    }

}
