<?php

namespace Opsuite\Inventory;

class ArrayOfAccountType implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AccountType[] $AccountType
     */
    protected $AccountType = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AccountType[]
     */
    public function getAccountType()
    {
      return $this->AccountType;
    }

    /**
     * @param AccountType[] $AccountType
     * @return \Opsuite\Inventory\ArrayOfAccountType
     */
    public function setAccountType(array $AccountType = null)
    {
      $this->AccountType = $AccountType;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AccountType[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AccountType
     */
    public function offsetGet($offset)
    {
      return $this->AccountType[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AccountType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AccountType[] = $value;
      } else {
        $this->AccountType[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AccountType[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AccountType Return the current element
     */
    public function current()
    {
      return current($this->AccountType);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AccountType);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AccountType);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AccountType);
    }

    /**
     * Countable implementation
     *
     * @return AccountType Return count of elements
     */
    public function count()
    {
      return count($this->AccountType);
    }

}
