<?php

namespace Opsuite\Customer;

class SubmitAccountReceivableHistory
{

    /**
     * @var string $accountNumber
     */
    protected $accountNumber = null;

    /**
     * @var int $batchNumber
     */
    protected $batchNumber = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var ArrayOfAccountReceivableHistory $accountReceivableHistory
     */
    protected $accountReceivableHistory = null;

    /**
     * @param string $accountNumber
     * @param int $batchNumber
     * @param int $locationId
     * @param ArrayOfAccountReceivableHistory $accountReceivableHistory
     */
    public function __construct($accountNumber, $batchNumber, $locationId, $accountReceivableHistory)
    {
      $this->accountNumber = $accountNumber;
      $this->batchNumber = $batchNumber;
      $this->locationId = $locationId;
      $this->accountReceivableHistory = $accountReceivableHistory;
    }

    /**
     * @return string
     */
    public function getAccountNumber()
    {
      return $this->accountNumber;
    }

    /**
     * @param string $accountNumber
     * @return \Opsuite\Customer\SubmitAccountReceivableHistory
     */
    public function setAccountNumber($accountNumber)
    {
      $this->accountNumber = $accountNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getBatchNumber()
    {
      return $this->batchNumber;
    }

    /**
     * @param int $batchNumber
     * @return \Opsuite\Customer\SubmitAccountReceivableHistory
     */
    public function setBatchNumber($batchNumber)
    {
      $this->batchNumber = $batchNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Customer\SubmitAccountReceivableHistory
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return ArrayOfAccountReceivableHistory
     */
    public function getAccountReceivableHistory()
    {
      return $this->accountReceivableHistory;
    }

    /**
     * @param ArrayOfAccountReceivableHistory $accountReceivableHistory
     * @return \Opsuite\Customer\SubmitAccountReceivableHistory
     */
    public function setAccountReceivableHistory($accountReceivableHistory)
    {
      $this->accountReceivableHistory = $accountReceivableHistory;
      return $this;
    }

}
