<?php

namespace Opsuite\Customer;

class OrderLine
{

    /**
     * @var string $Comment
     */
    protected $Comment = null;

    /**
     * @var CustomFields $CustomFields
     */
    protected $CustomFields = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $DiscountReasonCode
     */
    protected $DiscountReasonCode = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var ArrayOfTransactionLineBenefit $LineBenefits
     */
    protected $LineBenefits = null;

    /**
     * @var int $OrderId
     */
    protected $OrderId = null;

    /**
     * @var int $OrderLineId
     */
    protected $OrderLineId = null;

    /**
     * @var float $OrderPrice
     */
    protected $OrderPrice = null;

    /**
     * @var float $QuantityOnOrder
     */
    protected $QuantityOnOrder = null;

    /**
     * @var float $QuantityReceivedToDate
     */
    protected $QuantityReceivedToDate = null;

    /**
     * @var string $Sku
     */
    protected $Sku = null;

    /**
     * @var int $Taxable
     */
    protected $Taxable = null;

    /**
     * @var float $UnitCost
     */
    protected $UnitCost = null;

    /**
     * @var float $UnitListPrice
     */
    protected $UnitListPrice = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getComment()
    {
      return $this->Comment;
    }

    /**
     * @param string $Comment
     * @return \Opsuite\Customer\OrderLine
     */
    public function setComment($Comment)
    {
      $this->Comment = $Comment;
      return $this;
    }

    /**
     * @return CustomFields
     */
    public function getCustomFields()
    {
      return $this->CustomFields;
    }

    /**
     * @param CustomFields $CustomFields
     * @return \Opsuite\Customer\OrderLine
     */
    public function setCustomFields($CustomFields)
    {
      $this->CustomFields = $CustomFields;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Customer\OrderLine
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getDiscountReasonCode()
    {
      return $this->DiscountReasonCode;
    }

    /**
     * @param string $DiscountReasonCode
     * @return \Opsuite\Customer\OrderLine
     */
    public function setDiscountReasonCode($DiscountReasonCode)
    {
      $this->DiscountReasonCode = $DiscountReasonCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Customer\OrderLine
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfTransactionLineBenefit
     */
    public function getLineBenefits()
    {
      return $this->LineBenefits;
    }

    /**
     * @param ArrayOfTransactionLineBenefit $LineBenefits
     * @return \Opsuite\Customer\OrderLine
     */
    public function setLineBenefits($LineBenefits)
    {
      $this->LineBenefits = $LineBenefits;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderId()
    {
      return $this->OrderId;
    }

    /**
     * @param int $OrderId
     * @return \Opsuite\Customer\OrderLine
     */
    public function setOrderId($OrderId)
    {
      $this->OrderId = $OrderId;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderLineId()
    {
      return $this->OrderLineId;
    }

    /**
     * @param int $OrderLineId
     * @return \Opsuite\Customer\OrderLine
     */
    public function setOrderLineId($OrderLineId)
    {
      $this->OrderLineId = $OrderLineId;
      return $this;
    }

    /**
     * @return float
     */
    public function getOrderPrice()
    {
      return $this->OrderPrice;
    }

    /**
     * @param float $OrderPrice
     * @return \Opsuite\Customer\OrderLine
     */
    public function setOrderPrice($OrderPrice)
    {
      $this->OrderPrice = $OrderPrice;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityOnOrder()
    {
      return $this->QuantityOnOrder;
    }

    /**
     * @param float $QuantityOnOrder
     * @return \Opsuite\Customer\OrderLine
     */
    public function setQuantityOnOrder($QuantityOnOrder)
    {
      $this->QuantityOnOrder = $QuantityOnOrder;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityReceivedToDate()
    {
      return $this->QuantityReceivedToDate;
    }

    /**
     * @param float $QuantityReceivedToDate
     * @return \Opsuite\Customer\OrderLine
     */
    public function setQuantityReceivedToDate($QuantityReceivedToDate)
    {
      $this->QuantityReceivedToDate = $QuantityReceivedToDate;
      return $this;
    }

    /**
     * @return string
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param string $Sku
     * @return \Opsuite\Customer\OrderLine
     */
    public function setSku($Sku)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * @return int
     */
    public function getTaxable()
    {
      return $this->Taxable;
    }

    /**
     * @param int $Taxable
     * @return \Opsuite\Customer\OrderLine
     */
    public function setTaxable($Taxable)
    {
      $this->Taxable = $Taxable;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitCost()
    {
      return $this->UnitCost;
    }

    /**
     * @param float $UnitCost
     * @return \Opsuite\Customer\OrderLine
     */
    public function setUnitCost($UnitCost)
    {
      $this->UnitCost = $UnitCost;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitListPrice()
    {
      return $this->UnitListPrice;
    }

    /**
     * @param float $UnitListPrice
     * @return \Opsuite\Customer\OrderLine
     */
    public function setUnitListPrice($UnitListPrice)
    {
      $this->UnitListPrice = $UnitListPrice;
      return $this;
    }

}
