<?php

namespace Opsuite\Customer;

class Order
{

    /**
     * @var boolean $Closed
     */
    protected $Closed = null;

    /**
     * @var string $Comment
     */
    protected $Comment = null;

    /**
     * @var int $CustomerId
     */
    protected $CustomerId = null;

    /**
     * @var \DateTime $Date
     */
    protected $Date = null;

    /**
     * @var \DateTime $ExpirationOrDueDate
     */
    protected $ExpirationOrDueDate = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var int $OrderId
     */
    protected $OrderId = null;

    /**
     * @var ArrayOfOrderLine $OrderLines
     */
    protected $OrderLines = null;

    /**
     * @var OrderType $OrderType
     */
    protected $OrderType = null;

    /**
     * @var int $OrderTypeId
     */
    protected $OrderTypeId = null;

    /**
     * @var string $ReferenceNumber
     */
    protected $ReferenceNumber = null;

    /**
     * @var OrderShipTo $ShipTo
     */
    protected $ShipTo = null;

    /**
     * @var string $ShippingNotes
     */
    protected $ShippingNotes = null;

    /**
     * @var int $ShippingServiceId
     */
    protected $ShippingServiceId = null;

    /**
     * @var string $ShippingTrackingNumber
     */
    protected $ShippingTrackingNumber = null;

    /**
     * @var float $Tax
     */
    protected $Tax = null;

    /**
     * @var boolean $Taxable
     */
    protected $Taxable = null;

    /**
     * @var float $Total
     */
    protected $Total = null;

    /**
     * @var ArrayOfTransactionBenefit $TransactionBenefits
     */
    protected $TransactionBenefits = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getClosed()
    {
      return $this->Closed;
    }

    /**
     * @param boolean $Closed
     * @return \Opsuite\Customer\Order
     */
    public function setClosed($Closed)
    {
      $this->Closed = $Closed;
      return $this;
    }

    /**
     * @return string
     */
    public function getComment()
    {
      return $this->Comment;
    }

    /**
     * @param string $Comment
     * @return \Opsuite\Customer\Order
     */
    public function setComment($Comment)
    {
      $this->Comment = $Comment;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->CustomerId;
    }

    /**
     * @param int $CustomerId
     * @return \Opsuite\Customer\Order
     */
    public function setCustomerId($CustomerId)
    {
      $this->CustomerId = $CustomerId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
      if ($this->Date == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->Date);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $Date
     * @return \Opsuite\Customer\Order
     */
    public function setDate(\DateTime $Date = null)
    {
      if ($Date == null) {
       $this->Date = null;
      } else {
        $this->Date = $Date->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpirationOrDueDate()
    {
      if ($this->ExpirationOrDueDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ExpirationOrDueDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ExpirationOrDueDate
     * @return \Opsuite\Customer\Order
     */
    public function setExpirationOrDueDate(\DateTime $ExpirationOrDueDate = null)
    {
      if ($ExpirationOrDueDate == null) {
       $this->ExpirationOrDueDate = null;
      } else {
        $this->ExpirationOrDueDate = $ExpirationOrDueDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Customer\Order
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\Customer\Order
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderId()
    {
      return $this->OrderId;
    }

    /**
     * @param int $OrderId
     * @return \Opsuite\Customer\Order
     */
    public function setOrderId($OrderId)
    {
      $this->OrderId = $OrderId;
      return $this;
    }

    /**
     * @return ArrayOfOrderLine
     */
    public function getOrderLines()
    {
      return $this->OrderLines;
    }

    /**
     * @param ArrayOfOrderLine $OrderLines
     * @return \Opsuite\Customer\Order
     */
    public function setOrderLines($OrderLines)
    {
      $this->OrderLines = $OrderLines;
      return $this;
    }

    /**
     * @return OrderType
     */
    public function getOrderType()
    {
      return $this->OrderType;
    }

    /**
     * @param OrderType $OrderType
     * @return \Opsuite\Customer\Order
     */
    public function setOrderType($OrderType)
    {
      $this->OrderType = $OrderType;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderTypeId()
    {
      return $this->OrderTypeId;
    }

    /**
     * @param int $OrderTypeId
     * @return \Opsuite\Customer\Order
     */
    public function setOrderTypeId($OrderTypeId)
    {
      $this->OrderTypeId = $OrderTypeId;
      return $this;
    }

    /**
     * @return string
     */
    public function getReferenceNumber()
    {
      return $this->ReferenceNumber;
    }

    /**
     * @param string $ReferenceNumber
     * @return \Opsuite\Customer\Order
     */
    public function setReferenceNumber($ReferenceNumber)
    {
      $this->ReferenceNumber = $ReferenceNumber;
      return $this;
    }

    /**
     * @return OrderShipTo
     */
    public function getShipTo()
    {
      return $this->ShipTo;
    }

    /**
     * @param OrderShipTo $ShipTo
     * @return \Opsuite\Customer\Order
     */
    public function setShipTo($ShipTo)
    {
      $this->ShipTo = $ShipTo;
      return $this;
    }

    /**
     * @return string
     */
    public function getShippingNotes()
    {
      return $this->ShippingNotes;
    }

    /**
     * @param string $ShippingNotes
     * @return \Opsuite\Customer\Order
     */
    public function setShippingNotes($ShippingNotes)
    {
      $this->ShippingNotes = $ShippingNotes;
      return $this;
    }

    /**
     * @return int
     */
    public function getShippingServiceId()
    {
      return $this->ShippingServiceId;
    }

    /**
     * @param int $ShippingServiceId
     * @return \Opsuite\Customer\Order
     */
    public function setShippingServiceId($ShippingServiceId)
    {
      $this->ShippingServiceId = $ShippingServiceId;
      return $this;
    }

    /**
     * @return string
     */
    public function getShippingTrackingNumber()
    {
      return $this->ShippingTrackingNumber;
    }

    /**
     * @param string $ShippingTrackingNumber
     * @return \Opsuite\Customer\Order
     */
    public function setShippingTrackingNumber($ShippingTrackingNumber)
    {
      $this->ShippingTrackingNumber = $ShippingTrackingNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getTax()
    {
      return $this->Tax;
    }

    /**
     * @param float $Tax
     * @return \Opsuite\Customer\Order
     */
    public function setTax($Tax)
    {
      $this->Tax = $Tax;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTaxable()
    {
      return $this->Taxable;
    }

    /**
     * @param boolean $Taxable
     * @return \Opsuite\Customer\Order
     */
    public function setTaxable($Taxable)
    {
      $this->Taxable = $Taxable;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotal()
    {
      return $this->Total;
    }

    /**
     * @param float $Total
     * @return \Opsuite\Customer\Order
     */
    public function setTotal($Total)
    {
      $this->Total = $Total;
      return $this;
    }

    /**
     * @return ArrayOfTransactionBenefit
     */
    public function getTransactionBenefits()
    {
      return $this->TransactionBenefits;
    }

    /**
     * @param ArrayOfTransactionBenefit $TransactionBenefits
     * @return \Opsuite\Customer\Order
     */
    public function setTransactionBenefits($TransactionBenefits)
    {
      $this->TransactionBenefits = $TransactionBenefits;
      return $this;
    }

}
