<?php

namespace Opsuite\Customer;

class MultiStoreOrder
{

    /**
     * @var string $CashierNumber
     */
    protected $CashierNumber = null;

    /**
     * @var int $CustomerId
     */
    protected $CustomerId = null;

    /**
     * @var string $DeliveryComments
     */
    protected $DeliveryComments = null;

    /**
     * @var \DateTime $ExpirationOrDueDate
     */
    protected $ExpirationOrDueDate = null;

    /**
     * @var string $InternalDeliveryComments
     */
    protected $InternalDeliveryComments = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var string $OrderComments
     */
    protected $OrderComments = null;

    /**
     * @var \DateTime $OrderDate
     */
    protected $OrderDate = null;

    /**
     * @var ArrayOfMultiStoreOrderLine $OrderLines
     */
    protected $OrderLines = null;

    /**
     * @var string $ReferenceNumber
     */
    protected $ReferenceNumber = null;

    /**
     * @var int $RegisterNumber
     */
    protected $RegisterNumber = null;

    /**
     * @var int $ShipToId
     */
    protected $ShipToId = null;

    /**
     * @var int $StockLocationId
     */
    protected $StockLocationId = null;

    /**
     * @var int $TenderId
     */
    protected $TenderId = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getCashierNumber()
    {
      return $this->CashierNumber;
    }

    /**
     * @param string $CashierNumber
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setCashierNumber($CashierNumber)
    {
      $this->CashierNumber = $CashierNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->CustomerId;
    }

    /**
     * @param int $CustomerId
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setCustomerId($CustomerId)
    {
      $this->CustomerId = $CustomerId;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryComments()
    {
      return $this->DeliveryComments;
    }

    /**
     * @param string $DeliveryComments
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setDeliveryComments($DeliveryComments)
    {
      $this->DeliveryComments = $DeliveryComments;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpirationOrDueDate()
    {
      if ($this->ExpirationOrDueDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ExpirationOrDueDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ExpirationOrDueDate
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setExpirationOrDueDate(\DateTime $ExpirationOrDueDate = null)
    {
      if ($ExpirationOrDueDate == null) {
       $this->ExpirationOrDueDate = null;
      } else {
        $this->ExpirationOrDueDate = $ExpirationOrDueDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getInternalDeliveryComments()
    {
      return $this->InternalDeliveryComments;
    }

    /**
     * @param string $InternalDeliveryComments
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setInternalDeliveryComments($InternalDeliveryComments)
    {
      $this->InternalDeliveryComments = $InternalDeliveryComments;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderComments()
    {
      return $this->OrderComments;
    }

    /**
     * @param string $OrderComments
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setOrderComments($OrderComments)
    {
      $this->OrderComments = $OrderComments;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getOrderDate()
    {
      if ($this->OrderDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->OrderDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $OrderDate
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setOrderDate(\DateTime $OrderDate = null)
    {
      if ($OrderDate == null) {
       $this->OrderDate = null;
      } else {
        $this->OrderDate = $OrderDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfMultiStoreOrderLine
     */
    public function getOrderLines()
    {
      return $this->OrderLines;
    }

    /**
     * @param ArrayOfMultiStoreOrderLine $OrderLines
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setOrderLines($OrderLines)
    {
      $this->OrderLines = $OrderLines;
      return $this;
    }

    /**
     * @return string
     */
    public function getReferenceNumber()
    {
      return $this->ReferenceNumber;
    }

    /**
     * @param string $ReferenceNumber
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setReferenceNumber($ReferenceNumber)
    {
      $this->ReferenceNumber = $ReferenceNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getRegisterNumber()
    {
      return $this->RegisterNumber;
    }

    /**
     * @param int $RegisterNumber
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setRegisterNumber($RegisterNumber)
    {
      $this->RegisterNumber = $RegisterNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getShipToId()
    {
      return $this->ShipToId;
    }

    /**
     * @param int $ShipToId
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setShipToId($ShipToId)
    {
      $this->ShipToId = $ShipToId;
      return $this;
    }

    /**
     * @return int
     */
    public function getStockLocationId()
    {
      return $this->StockLocationId;
    }

    /**
     * @param int $StockLocationId
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setStockLocationId($StockLocationId)
    {
      $this->StockLocationId = $StockLocationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getTenderId()
    {
      return $this->TenderId;
    }

    /**
     * @param int $TenderId
     * @return \Opsuite\Customer\MultiStoreOrder
     */
    public function setTenderId($TenderId)
    {
      $this->TenderId = $TenderId;
      return $this;
    }

}
