<?php

namespace Opsuite\Customer;

class Invoice
{

    /**
     * @var string $CurrencyCode
     */
    protected $CurrencyCode = null;

    /**
     * @var float $ExchangeRate
     */
    protected $ExchangeRate = null;

    /**
     * @var \DateTime $InvoiceDate
     */
    protected $InvoiceDate = null;

    /**
     * @var ArrayOfInvoiceLine $InvoiceLines
     */
    protected $InvoiceLines = null;

    /**
     * @var string $InvoiceNumber
     */
    protected $InvoiceNumber = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    /**
     * @var InvoiceStatusTypeEnum $Status
     */
    protected $Status = null;

    /**
     * @var string $SupplierAccountNumber
     */
    protected $SupplierAccountNumber = null;

    /**
     * @var string $SupplierReference
     */
    protected $SupplierReference = null;

    /**
     * @var float $TotalTax
     */
    protected $TotalTax = null;

    /**
     * @var float $TotalValue
     */
    protected $TotalValue = null;

    /**
     * @var InvoiceTypeEnum $Type
     */
    protected $Type = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getCurrencyCode()
    {
      return $this->CurrencyCode;
    }

    /**
     * @param string $CurrencyCode
     * @return \Opsuite\Customer\Invoice
     */
    public function setCurrencyCode($CurrencyCode)
    {
      $this->CurrencyCode = $CurrencyCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getExchangeRate()
    {
      return $this->ExchangeRate;
    }

    /**
     * @param float $ExchangeRate
     * @return \Opsuite\Customer\Invoice
     */
    public function setExchangeRate($ExchangeRate)
    {
      $this->ExchangeRate = $ExchangeRate;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getInvoiceDate()
    {
      if ($this->InvoiceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->InvoiceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $InvoiceDate
     * @return \Opsuite\Customer\Invoice
     */
    public function setInvoiceDate(\DateTime $InvoiceDate = null)
    {
      if ($InvoiceDate == null) {
       $this->InvoiceDate = null;
      } else {
        $this->InvoiceDate = $InvoiceDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfInvoiceLine
     */
    public function getInvoiceLines()
    {
      return $this->InvoiceLines;
    }

    /**
     * @param ArrayOfInvoiceLine $InvoiceLines
     * @return \Opsuite\Customer\Invoice
     */
    public function setInvoiceLines($InvoiceLines)
    {
      $this->InvoiceLines = $InvoiceLines;
      return $this;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
      return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return \Opsuite\Customer\Invoice
     */
    public function setInvoiceNumber($InvoiceNumber)
    {
      $this->InvoiceNumber = $InvoiceNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\Customer\Invoice
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

    /**
     * @return InvoiceStatusTypeEnum
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param InvoiceStatusTypeEnum $Status
     * @return \Opsuite\Customer\Invoice
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierAccountNumber()
    {
      return $this->SupplierAccountNumber;
    }

    /**
     * @param string $SupplierAccountNumber
     * @return \Opsuite\Customer\Invoice
     */
    public function setSupplierAccountNumber($SupplierAccountNumber)
    {
      $this->SupplierAccountNumber = $SupplierAccountNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getSupplierReference()
    {
      return $this->SupplierReference;
    }

    /**
     * @param string $SupplierReference
     * @return \Opsuite\Customer\Invoice
     */
    public function setSupplierReference($SupplierReference)
    {
      $this->SupplierReference = $SupplierReference;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalTax()
    {
      return $this->TotalTax;
    }

    /**
     * @param float $TotalTax
     * @return \Opsuite\Customer\Invoice
     */
    public function setTotalTax($TotalTax)
    {
      $this->TotalTax = $TotalTax;
      return $this;
    }

    /**
     * @return float
     */
    public function getTotalValue()
    {
      return $this->TotalValue;
    }

    /**
     * @param float $TotalValue
     * @return \Opsuite\Customer\Invoice
     */
    public function setTotalValue($TotalValue)
    {
      $this->TotalValue = $TotalValue;
      return $this;
    }

    /**
     * @return InvoiceTypeEnum
     */
    public function getType()
    {
      return $this->Type;
    }

    /**
     * @param InvoiceTypeEnum $Type
     * @return \Opsuite\Customer\Invoice
     */
    public function setType($Type)
    {
      $this->Type = $Type;
      return $this;
    }

}
