<?php

namespace Opsuite\Customer;

class GetCustomersByDateTimeAndHomeLocation
{

    /**
     * @var DateFilterType $dateType
     */
    protected $dateType = null;

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var ArrayOfint $locationIds
     */
    protected $locationIds = null;

    /**
     * @param DateFilterType $dateType
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param ArrayOfint $locationIds
     */
    public function __construct($dateType, \DateTime $startDate, \DateTime $endDate, $locationIds)
    {
      $this->dateType = $dateType;
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->locationIds = $locationIds;
    }

    /**
     * @return DateFilterType
     */
    public function getDateType()
    {
      return $this->dateType;
    }

    /**
     * @param DateFilterType $dateType
     * @return \Opsuite\Customer\GetCustomersByDateTimeAndHomeLocation
     */
    public function setDateType($dateType)
    {
      $this->dateType = $dateType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\Customer\GetCustomersByDateTimeAndHomeLocation
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\Customer\GetCustomersByDateTimeAndHomeLocation
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return ArrayOfint
     */
    public function getLocationIds()
    {
      return $this->locationIds;
    }

    /**
     * @param ArrayOfint $locationIds
     * @return \Opsuite\Customer\GetCustomersByDateTimeAndHomeLocation
     */
    public function setLocationIds($locationIds)
    {
      $this->locationIds = $locationIds;
      return $this;
    }

}
