<?php

namespace Opsuite\Customer;

class GetCustomersByDateTime
{

    /**
     * @var DateFilterType $dateType
     */
    protected $dateType = null;

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @param DateFilterType $dateType
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     */
    public function __construct($dateType, \DateTime $startDate, \DateTime $endDate)
    {
      $this->dateType = $dateType;
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
    }

    /**
     * @return DateFilterType
     */
    public function getDateType()
    {
      return $this->dateType;
    }

    /**
     * @param DateFilterType $dateType
     * @return \Opsuite\Customer\GetCustomersByDateTime
     */
    public function setDateType($dateType)
    {
      $this->dateType = $dateType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\Customer\GetCustomersByDateTime
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\Customer\GetCustomersByDateTime
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

}
