<?php

namespace Opsuite\Customer;

class GetCustomerOrdersByLocation
{

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var \DateTime $creationDate
     */
    protected $creationDate = null;

    /**
     * @var boolean $includeClosed
     */
    protected $includeClosed = null;

    /**
     * @var \DateTime $lastUpdated
     */
    protected $lastUpdated = null;

    /**
     * @var int $orderTypeId
     */
    protected $orderTypeId = null;

    /**
     * @param int $locationId
     * @param \DateTime $creationDate
     * @param boolean $includeClosed
     * @param \DateTime $lastUpdated
     * @param int $orderTypeId
     */
    public function __construct($locationId, \DateTime $creationDate, $includeClosed, \DateTime $lastUpdated, $orderTypeId)
    {
      $this->locationId = $locationId;
      $this->creationDate = $creationDate->format(\DateTime::ATOM);
      $this->includeClosed = $includeClosed;
      $this->lastUpdated = $lastUpdated->format(\DateTime::ATOM);
      $this->orderTypeId = $orderTypeId;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Customer\GetCustomerOrdersByLocation
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreationDate()
    {
      if ($this->creationDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->creationDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $creationDate
     * @return \Opsuite\Customer\GetCustomerOrdersByLocation
     */
    public function setCreationDate(\DateTime $creationDate)
    {
      $this->creationDate = $creationDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeClosed()
    {
      return $this->includeClosed;
    }

    /**
     * @param boolean $includeClosed
     * @return \Opsuite\Customer\GetCustomerOrdersByLocation
     */
    public function setIncludeClosed($includeClosed)
    {
      $this->includeClosed = $includeClosed;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->lastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->lastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $lastUpdated
     * @return \Opsuite\Customer\GetCustomerOrdersByLocation
     */
    public function setLastUpdated(\DateTime $lastUpdated)
    {
      $this->lastUpdated = $lastUpdated->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderTypeId()
    {
      return $this->orderTypeId;
    }

    /**
     * @param int $orderTypeId
     * @return \Opsuite\Customer\GetCustomerOrdersByLocation
     */
    public function setOrderTypeId($orderTypeId)
    {
      $this->orderTypeId = $orderTypeId;
      return $this;
    }

}
