<?php

namespace Opsuite\Customer;

class GetApprovedInvoices
{

    /**
     * @var boolean $includeExported
     */
    protected $includeExported = null;

    /**
     * @var \DateTime $invoiceDateTime
     */
    protected $invoiceDateTime = null;

    /**
     * @param boolean $includeExported
     * @param \DateTime $invoiceDateTime
     */
    public function __construct($includeExported, \DateTime $invoiceDateTime)
    {
      $this->includeExported = $includeExported;
      $this->invoiceDateTime = $invoiceDateTime->format(\DateTime::ATOM);
    }

    /**
     * @return boolean
     */
    public function getIncludeExported()
    {
      return $this->includeExported;
    }

    /**
     * @param boolean $includeExported
     * @return \Opsuite\Customer\GetApprovedInvoices
     */
    public function setIncludeExported($includeExported)
    {
      $this->includeExported = $includeExported;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getInvoiceDateTime()
    {
      if ($this->invoiceDateTime == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->invoiceDateTime);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $invoiceDateTime
     * @return \Opsuite\Customer\GetApprovedInvoices
     */
    public function setInvoiceDateTime(\DateTime $invoiceDateTime)
    {
      $this->invoiceDateTime = $invoiceDateTime->format(\DateTime::ATOM);
      return $this;
    }

}
