<?php

namespace Opsuite\Customer;

class GetAccountReceivables
{

    /**
     * @var string $customerAccountNumber
     */
    protected $customerAccountNumber = null;

    /**
     * @var AccountReceivableAccountReceivableTypeEnum $type
     */
    protected $type = null;

    /**
     * @var boolean $excludeZeroBalance
     */
    protected $excludeZeroBalance = null;

    /**
     * @param string $customerAccountNumber
     * @param AccountReceivableAccountReceivableTypeEnum $type
     * @param boolean $excludeZeroBalance
     */
    public function __construct($customerAccountNumber, $type, $excludeZeroBalance)
    {
      $this->customerAccountNumber = $customerAccountNumber;
      $this->type = $type;
      $this->excludeZeroBalance = $excludeZeroBalance;
    }

    /**
     * @return string
     */
    public function getCustomerAccountNumber()
    {
      return $this->customerAccountNumber;
    }

    /**
     * @param string $customerAccountNumber
     * @return \Opsuite\Customer\GetAccountReceivables
     */
    public function setCustomerAccountNumber($customerAccountNumber)
    {
      $this->customerAccountNumber = $customerAccountNumber;
      return $this;
    }

    /**
     * @return AccountReceivableAccountReceivableTypeEnum
     */
    public function getType()
    {
      return $this->type;
    }

    /**
     * @param AccountReceivableAccountReceivableTypeEnum $type
     * @return \Opsuite\Customer\GetAccountReceivables
     */
    public function setType($type)
    {
      $this->type = $type;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getExcludeZeroBalance()
    {
      return $this->excludeZeroBalance;
    }

    /**
     * @param boolean $excludeZeroBalance
     * @return \Opsuite\Customer\GetAccountReceivables
     */
    public function setExcludeZeroBalance($excludeZeroBalance)
    {
      $this->excludeZeroBalance = $excludeZeroBalance;
      return $this;
    }

}
