<?php

namespace Opsuite\Customer;

use Opsuite\WSSSoapClient;

class CustomerService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfContact' => 'Opsuite\\Customer\\ArrayOfContact',
      'Contact' => 'Opsuite\\Customer\\Contact',
      'CustomFields' => 'Opsuite\\Customer\\CustomFields',
      'ArrayOfTransactionLineBenefit' => 'Opsuite\\Customer\\ArrayOfTransactionLineBenefit',
      'TransactionLineBenefit' => 'Opsuite\\Customer\\TransactionLineBenefit',
      'ArrayOfTransactionBenefit' => 'Opsuite\\Customer\\ArrayOfTransactionBenefit',
      'TransactionBenefit' => 'Opsuite\\Customer\\TransactionBenefit',
      'ArrayOfCustomer' => 'Opsuite\\Customer\\ArrayOfCustomer',
      'Customer' => 'Opsuite\\Customer\\Customer',
      'ArrayOfOrder' => 'Opsuite\\Customer\\ArrayOfOrder',
      'Order' => 'Opsuite\\Customer\\Order',
      'ArrayOfOrderLine' => 'Opsuite\\Customer\\ArrayOfOrderLine',
      'OrderLine' => 'Opsuite\\Customer\\OrderLine',
      'OrderType' => 'Opsuite\\Customer\\OrderType',
      'OrderShipTo' => 'Opsuite\\Customer\\OrderShipTo',
      'ArrayOfAccountReceivable' => 'Opsuite\\Customer\\ArrayOfAccountReceivable',
      'AccountReceivable' => 'Opsuite\\Customer\\AccountReceivable',
      'ArrayOfAccountReceivableHistory' => 'Opsuite\\Customer\\ArrayOfAccountReceivableHistory',
      'AccountReceivableHistory' => 'Opsuite\\Customer\\AccountReceivableHistory',
      'ArrayOfInvoice' => 'Opsuite\\Customer\\ArrayOfInvoice',
      'Invoice' => 'Opsuite\\Customer\\Invoice',
      'ArrayOfInvoiceLine' => 'Opsuite\\Customer\\ArrayOfInvoiceLine',
      'InvoiceLine' => 'Opsuite\\Customer\\InvoiceLine',
      'ArrayOfCustomerLoyaltyField' => 'Opsuite\\Customer\\ArrayOfCustomerLoyaltyField',
      'CustomerLoyaltyField' => 'Opsuite\\Customer\\CustomerLoyaltyField',
      'ArrayOfAccountType' => 'Opsuite\\Customer\\ArrayOfAccountType',
      'AccountType' => 'Opsuite\\Customer\\AccountType',
      'MultiStoreOrder' => 'Opsuite\\Customer\\MultiStoreOrder',
      'ArrayOfMultiStoreOrderLine' => 'Opsuite\\Customer\\ArrayOfMultiStoreOrderLine',
      'MultiStoreOrderLine' => 'Opsuite\\Customer\\MultiStoreOrderLine',
      'ArrayOfint' => 'Opsuite\\Customer\\ArrayOfint',
      'ArrayOfstring' => 'Opsuite\\Customer\\ArrayOfstring',
      'SubmitResultOfCustomer5BGqnr0R' => 'Opsuite\\Customer\\SubmitResultOfCustomer5BGqnr0R',
      'ArrayOfErrorInfoOfCustomer5BGqnr0R' => 'Opsuite\\Customer\\ArrayOfErrorInfoOfCustomer5BGqnr0R',
      'ErrorInfoOfCustomer5BGqnr0R' => 'Opsuite\\Customer\\ErrorInfoOfCustomer5BGqnr0R',
      'SubmitResultOfOrder5BGqnr0R' => 'Opsuite\\Customer\\SubmitResultOfOrder5BGqnr0R',
      'ArrayOfErrorInfoOfOrder5BGqnr0R' => 'Opsuite\\Customer\\ArrayOfErrorInfoOfOrder5BGqnr0R',
      'ErrorInfoOfOrder5BGqnr0R' => 'Opsuite\\Customer\\ErrorInfoOfOrder5BGqnr0R',
      'SubmitResultOfAccountReceivable5BGqnr0R' => 'Opsuite\\Customer\\SubmitResultOfAccountReceivable5BGqnr0R',
      'ArrayOfErrorInfoOfAccountReceivable5BGqnr0R' => 'Opsuite\\Customer\\ArrayOfErrorInfoOfAccountReceivable5BGqnr0R',
      'ErrorInfoOfAccountReceivable5BGqnr0R' => 'Opsuite\\Customer\\ErrorInfoOfAccountReceivable5BGqnr0R',
      'ArrayOfSubmitResultOfAccountReceivableHistory5BGqnr0R' => 'Opsuite\\Customer\\ArrayOfSubmitResultOfAccountReceivableHistory5BGqnr0R',
      'SubmitResultOfAccountReceivableHistory5BGqnr0R' => 'Opsuite\\Customer\\SubmitResultOfAccountReceivableHistory5BGqnr0R',
      'ArrayOfErrorInfoOfAccountReceivableHistory5BGqnr0R' => 'Opsuite\\Customer\\ArrayOfErrorInfoOfAccountReceivableHistory5BGqnr0R',
      'ErrorInfoOfAccountReceivableHistory5BGqnr0R' => 'Opsuite\\Customer\\ErrorInfoOfAccountReceivableHistory5BGqnr0R',
      'SubmitResultOfMultiStoreOrder5BGqnr0R' => 'Opsuite\\Customer\\SubmitResultOfMultiStoreOrder5BGqnr0R',
      'ArrayOfErrorInfoOfMultiStoreOrder5BGqnr0R' => 'Opsuite\\Customer\\ArrayOfErrorInfoOfMultiStoreOrder5BGqnr0R',
      'ErrorInfoOfMultiStoreOrder5BGqnr0R' => 'Opsuite\\Customer\\ErrorInfoOfMultiStoreOrder5BGqnr0R',
      'GetLoyaltyBalance' => 'Opsuite\\Customer\\GetLoyaltyBalance',
      'GetLoyaltyBalanceResponse' => 'Opsuite\\Customer\\GetLoyaltyBalanceResponse',
      'AddLoyaltyTransaction' => 'Opsuite\\Customer\\AddLoyaltyTransaction',
      'AddLoyaltyTransactionResponse' => 'Opsuite\\Customer\\AddLoyaltyTransactionResponse',
      'AddTransactionToCustomer' => 'Opsuite\\Customer\\AddTransactionToCustomer',
      'AddTransactionToCustomerResponse' => 'Opsuite\\Customer\\AddTransactionToCustomerResponse',
      'CustomerExists' => 'Opsuite\\Customer\\CustomerExists',
      'CustomerExistsResponse' => 'Opsuite\\Customer\\CustomerExistsResponse',
      'GetCustomers' => 'Opsuite\\Customer\\GetCustomers',
      'GetCustomersResponse' => 'Opsuite\\Customer\\GetCustomersResponse',
      'GetCustomerById' => 'Opsuite\\Customer\\GetCustomerById',
      'GetCustomerByIdResponse' => 'Opsuite\\Customer\\GetCustomerByIdResponse',
      'GetCustomersByEmail' => 'Opsuite\\Customer\\GetCustomersByEmail',
      'GetCustomersByEmailResponse' => 'Opsuite\\Customer\\GetCustomersByEmailResponse',
      'GetCustomersByEmailAndCustomText2' => 'Opsuite\\Customer\\GetCustomersByEmailAndCustomText2',
      'GetCustomersByEmailAndCustomText2Response' => 'Opsuite\\Customer\\GetCustomersByEmailAndCustomText2Response',
      'GetCustomersByIds' => 'Opsuite\\Customer\\GetCustomersByIds',
      'GetCustomersByIdsResponse' => 'Opsuite\\Customer\\GetCustomersByIdsResponse',
      'GetCustomerByAccountNumber' => 'Opsuite\\Customer\\GetCustomerByAccountNumber',
      'GetCustomerByAccountNumberResponse' => 'Opsuite\\Customer\\GetCustomerByAccountNumberResponse',
      'GetCustomersByDateTime' => 'Opsuite\\Customer\\GetCustomersByDateTime',
      'GetCustomersByDateTimeResponse' => 'Opsuite\\Customer\\GetCustomersByDateTimeResponse',
      'GetCustomersByDateTimeAndHomeLocation' => 'Opsuite\\Customer\\GetCustomersByDateTimeAndHomeLocation',
      'GetCustomersByDateTimeAndHomeLocationResponse' => 'Opsuite\\Customer\\GetCustomersByDateTimeAndHomeLocationResponse',
      'SubmitCustomer' => 'Opsuite\\Customer\\SubmitCustomer',
      'SubmitCustomerResponse' => 'Opsuite\\Customer\\SubmitCustomerResponse',
      'GetCustomerOrdersByLocation' => 'Opsuite\\Customer\\GetCustomerOrdersByLocation',
      'GetCustomerOrdersByLocationResponse' => 'Opsuite\\Customer\\GetCustomerOrdersByLocationResponse',
      'SubmitOrder' => 'Opsuite\\Customer\\SubmitOrder',
      'SubmitOrderResponse' => 'Opsuite\\Customer\\SubmitOrderResponse',
      'GetAccountReceivables' => 'Opsuite\\Customer\\GetAccountReceivables',
      'GetAccountReceivablesResponse' => 'Opsuite\\Customer\\GetAccountReceivablesResponse',
      'SubmitAccountReceivable' => 'Opsuite\\Customer\\SubmitAccountReceivable',
      'SubmitAccountReceivableResponse' => 'Opsuite\\Customer\\SubmitAccountReceivableResponse',
      'SubmitAccountReceivableHistory' => 'Opsuite\\Customer\\SubmitAccountReceivableHistory',
      'SubmitAccountReceivableHistoryResponse' => 'Opsuite\\Customer\\SubmitAccountReceivableHistoryResponse',
      'GetApprovedInvoices' => 'Opsuite\\Customer\\GetApprovedInvoices',
      'GetApprovedInvoicesResponse' => 'Opsuite\\Customer\\GetApprovedInvoicesResponse',
      'SubmitExportedInvoices' => 'Opsuite\\Customer\\SubmitExportedInvoices',
      'SubmitExportedInvoicesResponse' => 'Opsuite\\Customer\\SubmitExportedInvoicesResponse',
      'SubmitPaidInvoices' => 'Opsuite\\Customer\\SubmitPaidInvoices',
      'SubmitPaidInvoicesResponse' => 'Opsuite\\Customer\\SubmitPaidInvoicesResponse',
      'GetCustomerLoyaltyFieldsForCustomer' => 'Opsuite\\Customer\\GetCustomerLoyaltyFieldsForCustomer',
      'GetCustomerLoyaltyFieldsForCustomerResponse' => 'Opsuite\\Customer\\GetCustomerLoyaltyFieldsForCustomerResponse',
      'GetCustomerLoyaltyFieldsForCustomerAccountNumber' => 'Opsuite\\Customer\\GetCustomerLoyaltyFieldsForCustomerAccountNumber',
      'GetCustomerLoyaltyFieldsForCustomerAccountNumberResponse' => 'Opsuite\\Customer\\GetCustomerLoyaltyFieldsForCustomerAccountNumberResponse',
      'GetCustomerLoyaltyFieldsForLoyaltyCardNumber' => 'Opsuite\\Customer\\GetCustomerLoyaltyFieldsForLoyaltyCardNumber',
      'GetCustomerLoyaltyFieldsForLoyaltyCardNumberResponse' => 'Opsuite\\Customer\\GetCustomerLoyaltyFieldsForLoyaltyCardNumberResponse',
      'GetAccountTypes' => 'Opsuite\\Customer\\GetAccountTypes',
      'GetAccountTypesResponse' => 'Opsuite\\Customer\\GetAccountTypesResponse',
      'SubmitMultiStoreOrder' => 'Opsuite\\Customer\\SubmitMultiStoreOrder',
      'SubmitMultiStoreOrderResponse' => 'Opsuite\\Customer\\SubmitMultiStoreOrderResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/CustomerService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetLoyaltyBalance $parameters
     * @return GetLoyaltyBalanceResponse
     */
    public function GetLoyaltyBalance(GetLoyaltyBalance $parameters)
    {
      return $this->__soapCall('GetLoyaltyBalance', array($parameters));
    }

    /**
     * @param AddLoyaltyTransaction $parameters
     * @return AddLoyaltyTransactionResponse
     */
    public function AddLoyaltyTransaction(AddLoyaltyTransaction $parameters)
    {
      return $this->__soapCall('AddLoyaltyTransaction', array($parameters));
    }

    /**
     * @param AddTransactionToCustomer $parameters
     * @return AddTransactionToCustomerResponse
     */
    public function AddTransactionToCustomer(AddTransactionToCustomer $parameters)
    {
      return $this->__soapCall('AddTransactionToCustomer', array($parameters));
    }

    /**
     * @param CustomerExists $parameters
     * @return CustomerExistsResponse
     */
    public function CustomerExists(CustomerExists $parameters)
    {
      return $this->__soapCall('CustomerExists', array($parameters));
    }

    /**
     * @param GetCustomers $parameters
     * @return GetCustomersResponse
     */
    public function GetCustomers(GetCustomers $parameters)
    {
      return $this->__soapCall('GetCustomers', array($parameters));
    }

    /**
     * @param GetCustomerById $parameters
     * @return GetCustomerByIdResponse
     */
    public function GetCustomerById(GetCustomerById $parameters)
    {
      return $this->__soapCall('GetCustomerById', array($parameters));
    }

    /**
     * @param GetCustomersByEmail $parameters
     * @return GetCustomersByEmailResponse
     */
    public function GetCustomersByEmail(GetCustomersByEmail $parameters)
    {
      return $this->__soapCall('GetCustomersByEmail', array($parameters));
    }

    /**
     * @param GetCustomersByEmailAndCustomText2 $parameters
     * @return GetCustomersByEmailAndCustomText2Response
     */
    public function GetCustomersByEmailAndCustomText2(GetCustomersByEmailAndCustomText2 $parameters)
    {
      return $this->__soapCall('GetCustomersByEmailAndCustomText2', array($parameters));
    }

    /**
     * @param GetCustomersByIds $parameters
     * @return GetCustomersByIdsResponse
     */
    public function GetCustomersByIds(GetCustomersByIds $parameters)
    {
      return $this->__soapCall('GetCustomersByIds', array($parameters));
    }

    /**
     * @param GetCustomerByAccountNumber $parameters
     * @return GetCustomerByAccountNumberResponse
     */
    public function GetCustomerByAccountNumber(GetCustomerByAccountNumber $parameters)
    {
      return $this->__soapCall('GetCustomerByAccountNumber', array($parameters));
    }

    /**
     * @param GetCustomersByDateTime $parameters
     * @return GetCustomersByDateTimeResponse
     */
    public function GetCustomersByDateTime(GetCustomersByDateTime $parameters)
    {
      return $this->__soapCall('GetCustomersByDateTime', array($parameters));
    }

    /**
     * @param GetCustomersByDateTimeAndHomeLocation $parameters
     * @return GetCustomersByDateTimeAndHomeLocationResponse
     */
    public function GetCustomersByDateTimeAndHomeLocation(GetCustomersByDateTimeAndHomeLocation $parameters)
    {
      return $this->__soapCall('GetCustomersByDateTimeAndHomeLocation', array($parameters));
    }

    /**
     * @param SubmitCustomer $parameters
     * @return SubmitCustomerResponse
     */
    public function SubmitCustomer(SubmitCustomer $parameters)
    {
      return $this->__soapCall('SubmitCustomer', array($parameters));
    }

    /**
     * @param GetCustomerOrdersByLocation $parameters
     * @return GetCustomerOrdersByLocationResponse
     */
    public function GetCustomerOrdersByLocation(GetCustomerOrdersByLocation $parameters)
    {
      return $this->__soapCall('GetCustomerOrdersByLocation', array($parameters));
    }

    /**
     * @param SubmitOrder $parameters
     * @return SubmitOrderResponse
     */
    public function SubmitOrder(SubmitOrder $parameters)
    {
      return $this->__soapCall('SubmitOrder', array($parameters));
    }

    /**
     * @param GetAccountReceivables $parameters
     * @return GetAccountReceivablesResponse
     */
    public function GetAccountReceivables(GetAccountReceivables $parameters)
    {
      return $this->__soapCall('GetAccountReceivables', array($parameters));
    }

    /**
     * @param SubmitAccountReceivable $parameters
     * @return SubmitAccountReceivableResponse
     */
    public function SubmitAccountReceivable(SubmitAccountReceivable $parameters)
    {
      return $this->__soapCall('SubmitAccountReceivable', array($parameters));
    }

    /**
     * @param SubmitAccountReceivableHistory $parameters
     * @return SubmitAccountReceivableHistoryResponse
     */
    public function SubmitAccountReceivableHistory(SubmitAccountReceivableHistory $parameters)
    {
      return $this->__soapCall('SubmitAccountReceivableHistory', array($parameters));
    }

    /**
     * @param GetApprovedInvoices $parameters
     * @return GetApprovedInvoicesResponse
     */
    public function GetApprovedInvoices(GetApprovedInvoices $parameters)
    {
      return $this->__soapCall('GetApprovedInvoices', array($parameters));
    }

    /**
     * @param SubmitExportedInvoices $parameters
     * @return SubmitExportedInvoicesResponse
     */
    public function SubmitExportedInvoices(SubmitExportedInvoices $parameters)
    {
      return $this->__soapCall('SubmitExportedInvoices', array($parameters));
    }

    /**
     * @param SubmitPaidInvoices $parameters
     * @return SubmitPaidInvoicesResponse
     */
    public function SubmitPaidInvoices(SubmitPaidInvoices $parameters)
    {
      return $this->__soapCall('SubmitPaidInvoices', array($parameters));
    }

    /**
     * @param GetCustomerLoyaltyFieldsForCustomer $parameters
     * @return GetCustomerLoyaltyFieldsForCustomerResponse
     */
    public function GetCustomerLoyaltyFieldsForCustomer(GetCustomerLoyaltyFieldsForCustomer $parameters)
    {
      return $this->__soapCall('GetCustomerLoyaltyFieldsForCustomer', array($parameters));
    }

    /**
     * @param GetCustomerLoyaltyFieldsForCustomerAccountNumber $parameters
     * @return GetCustomerLoyaltyFieldsForCustomerAccountNumberResponse
     */
    public function GetCustomerLoyaltyFieldsForCustomerAccountNumber(GetCustomerLoyaltyFieldsForCustomerAccountNumber $parameters)
    {
      return $this->__soapCall('GetCustomerLoyaltyFieldsForCustomerAccountNumber', array($parameters));
    }

    /**
     * @param GetCustomerLoyaltyFieldsForLoyaltyCardNumber $parameters
     * @return GetCustomerLoyaltyFieldsForLoyaltyCardNumberResponse
     */
    public function GetCustomerLoyaltyFieldsForLoyaltyCardNumber(GetCustomerLoyaltyFieldsForLoyaltyCardNumber $parameters)
    {
      return $this->__soapCall('GetCustomerLoyaltyFieldsForLoyaltyCardNumber', array($parameters));
    }

    /**
     * @param GetAccountTypes $parameters
     * @return GetAccountTypesResponse
     */
    public function GetAccountTypes(GetAccountTypes $parameters)
    {
      return $this->__soapCall('GetAccountTypes', array($parameters));
    }

    /**
     * @param SubmitMultiStoreOrder $parameters
     * @return SubmitMultiStoreOrderResponse
     */
    public function SubmitMultiStoreOrder(SubmitMultiStoreOrder $parameters)
    {
      return $this->__soapCall('SubmitMultiStoreOrder', array($parameters));
    }

}
