<?php

namespace Opsuite\Customer;

class Customer
{

    /**
     * @var string $AccountNumber
     */
    protected $AccountNumber = null;

    /**
     * @var string $AccountTypeDescription
     */
    protected $AccountTypeDescription = null;

    /**
     * @var int $AccountTypeId
     */
    protected $AccountTypeId = null;

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var string $AddressLine1
     */
    protected $AddressLine1 = null;

    /**
     * @var string $AddressLine2
     */
    protected $AddressLine2 = null;

    /**
     * @var string $AddressLine3
     */
    protected $AddressLine3 = null;

    /**
     * @var string $AddressLine4
     */
    protected $AddressLine4 = null;

    /**
     * @var string $City
     */
    protected $City = null;

    /**
     * @var string $Company
     */
    protected $Company = null;

    /**
     * @var ArrayOfContact $Contacts
     */
    protected $Contacts = null;

    /**
     * @var float $CreditLimit
     */
    protected $CreditLimit = null;

    /**
     * @var \DateTime $CustomDate1
     */
    protected $CustomDate1 = null;

    /**
     * @var \DateTime $CustomDate2
     */
    protected $CustomDate2 = null;

    /**
     * @var \DateTime $CustomDate3
     */
    protected $CustomDate3 = null;

    /**
     * @var \DateTime $CustomDate4
     */
    protected $CustomDate4 = null;

    /**
     * @var \DateTime $CustomDate5
     */
    protected $CustomDate5 = null;

    /**
     * @var float $CustomNumber1
     */
    protected $CustomNumber1 = null;

    /**
     * @var float $CustomNumber2
     */
    protected $CustomNumber2 = null;

    /**
     * @var float $CustomNumber3
     */
    protected $CustomNumber3 = null;

    /**
     * @var float $CustomNumber4
     */
    protected $CustomNumber4 = null;

    /**
     * @var float $CustomNumber5
     */
    protected $CustomNumber5 = null;

    /**
     * @var string $CustomText1
     */
    protected $CustomText1 = null;

    /**
     * @var string $CustomText2
     */
    protected $CustomText2 = null;

    /**
     * @var string $CustomText3
     */
    protected $CustomText3 = null;

    /**
     * @var string $CustomText4
     */
    protected $CustomText4 = null;

    /**
     * @var string $CustomText5
     */
    protected $CustomText5 = null;

    /**
     * @var int $CustomerId
     */
    protected $CustomerId = null;

    /**
     * @var \DateTime $DateOfBirth
     */
    protected $DateOfBirth = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @var string $FaxNumber
     */
    protected $FaxNumber = null;

    /**
     * @var string $FirstName
     */
    protected $FirstName = null;

    /**
     * @var string $IsoCountryCode
     */
    protected $IsoCountryCode = null;

    /**
     * @var \DateTime $LastClosingDate
     */
    protected $LastClosingDate = null;

    /**
     * @var string $LastName
     */
    protected $LastName = null;

    /**
     * @var \DateTime $LastStartingDate
     */
    protected $LastStartingDate = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var \DateTime $LastVisit
     */
    protected $LastVisit = null;

    /**
     * @var int $LocationGroupId
     */
    protected $LocationGroupId = null;

    /**
     * @var string $Notes
     */
    protected $Notes = null;

    /**
     * @var boolean $OptInDirectMail
     */
    protected $OptInDirectMail = null;

    /**
     * @var boolean $OptInEmail
     */
    protected $OptInEmail = null;

    /**
     * @var boolean $OptInTelephone
     */
    protected $OptInTelephone = null;

    /**
     * @var int $OriginationLocationId
     */
    protected $OriginationLocationId = null;

    /**
     * @var string $ReferredBy
     */
    protected $ReferredBy = null;

    /**
     * @var string $SignedUpBy
     */
    protected $SignedUpBy = null;

    /**
     * @var boolean $TaxExempt
     */
    protected $TaxExempt = null;

    /**
     * @var string $TelephoneNumber
     */
    protected $TelephoneNumber = null;

    /**
     * @var string $Territory
     */
    protected $Territory = null;

    /**
     * @var int $TitleId
     */
    protected $TitleId = null;

    /**
     * @var string $Zip
     */
    protected $Zip = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getAccountNumber()
    {
      return $this->AccountNumber;
    }

    /**
     * @param string $AccountNumber
     * @return \Opsuite\Customer\Customer
     */
    public function setAccountNumber($AccountNumber)
    {
      $this->AccountNumber = $AccountNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getAccountTypeDescription()
    {
      return $this->AccountTypeDescription;
    }

    /**
     * @param string $AccountTypeDescription
     * @return \Opsuite\Customer\Customer
     */
    public function setAccountTypeDescription($AccountTypeDescription)
    {
      $this->AccountTypeDescription = $AccountTypeDescription;
      return $this;
    }

    /**
     * @return int
     */
    public function getAccountTypeId()
    {
      return $this->AccountTypeId;
    }

    /**
     * @param int $AccountTypeId
     * @return \Opsuite\Customer\Customer
     */
    public function setAccountTypeId($AccountTypeId)
    {
      $this->AccountTypeId = $AccountTypeId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Customer\Customer
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine1()
    {
      return $this->AddressLine1;
    }

    /**
     * @param string $AddressLine1
     * @return \Opsuite\Customer\Customer
     */
    public function setAddressLine1($AddressLine1)
    {
      $this->AddressLine1 = $AddressLine1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
      return $this->AddressLine2;
    }

    /**
     * @param string $AddressLine2
     * @return \Opsuite\Customer\Customer
     */
    public function setAddressLine2($AddressLine2)
    {
      $this->AddressLine2 = $AddressLine2;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine3()
    {
      return $this->AddressLine3;
    }

    /**
     * @param string $AddressLine3
     * @return \Opsuite\Customer\Customer
     */
    public function setAddressLine3($AddressLine3)
    {
      $this->AddressLine3 = $AddressLine3;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine4()
    {
      return $this->AddressLine4;
    }

    /**
     * @param string $AddressLine4
     * @return \Opsuite\Customer\Customer
     */
    public function setAddressLine4($AddressLine4)
    {
      $this->AddressLine4 = $AddressLine4;
      return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
      return $this->City;
    }

    /**
     * @param string $City
     * @return \Opsuite\Customer\Customer
     */
    public function setCity($City)
    {
      $this->City = $City;
      return $this;
    }

    /**
     * @return string
     */
    public function getCompany()
    {
      return $this->Company;
    }

    /**
     * @param string $Company
     * @return \Opsuite\Customer\Customer
     */
    public function setCompany($Company)
    {
      $this->Company = $Company;
      return $this;
    }

    /**
     * @return ArrayOfContact
     */
    public function getContacts()
    {
      return $this->Contacts;
    }

    /**
     * @param ArrayOfContact $Contacts
     * @return \Opsuite\Customer\Customer
     */
    public function setContacts($Contacts)
    {
      $this->Contacts = $Contacts;
      return $this;
    }

    /**
     * @return float
     */
    public function getCreditLimit()
    {
      return $this->CreditLimit;
    }

    /**
     * @param float $CreditLimit
     * @return \Opsuite\Customer\Customer
     */
    public function setCreditLimit($CreditLimit)
    {
      $this->CreditLimit = $CreditLimit;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate1()
    {
      if ($this->CustomDate1 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate1);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate1
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomDate1(\DateTime $CustomDate1 = null)
    {
      if ($CustomDate1 == null) {
       $this->CustomDate1 = null;
      } else {
        $this->CustomDate1 = $CustomDate1->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate2()
    {
      if ($this->CustomDate2 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate2);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate2
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomDate2(\DateTime $CustomDate2 = null)
    {
      if ($CustomDate2 == null) {
       $this->CustomDate2 = null;
      } else {
        $this->CustomDate2 = $CustomDate2->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate3()
    {
      if ($this->CustomDate3 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate3);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate3
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomDate3(\DateTime $CustomDate3 = null)
    {
      if ($CustomDate3 == null) {
       $this->CustomDate3 = null;
      } else {
        $this->CustomDate3 = $CustomDate3->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate4()
    {
      if ($this->CustomDate4 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate4);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate4
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomDate4(\DateTime $CustomDate4 = null)
    {
      if ($CustomDate4 == null) {
       $this->CustomDate4 = null;
      } else {
        $this->CustomDate4 = $CustomDate4->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCustomDate5()
    {
      if ($this->CustomDate5 == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CustomDate5);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CustomDate5
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomDate5(\DateTime $CustomDate5 = null)
    {
      if ($CustomDate5 == null) {
       $this->CustomDate5 = null;
      } else {
        $this->CustomDate5 = $CustomDate5->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomNumber1()
    {
      return $this->CustomNumber1;
    }

    /**
     * @param float $CustomNumber1
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomNumber1($CustomNumber1)
    {
      $this->CustomNumber1 = $CustomNumber1;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomNumber2()
    {
      return $this->CustomNumber2;
    }

    /**
     * @param float $CustomNumber2
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomNumber2($CustomNumber2)
    {
      $this->CustomNumber2 = $CustomNumber2;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomNumber3()
    {
      return $this->CustomNumber3;
    }

    /**
     * @param float $CustomNumber3
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomNumber3($CustomNumber3)
    {
      $this->CustomNumber3 = $CustomNumber3;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomNumber4()
    {
      return $this->CustomNumber4;
    }

    /**
     * @param float $CustomNumber4
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomNumber4($CustomNumber4)
    {
      $this->CustomNumber4 = $CustomNumber4;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomNumber5()
    {
      return $this->CustomNumber5;
    }

    /**
     * @param float $CustomNumber5
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomNumber5($CustomNumber5)
    {
      $this->CustomNumber5 = $CustomNumber5;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomText1()
    {
      return $this->CustomText1;
    }

    /**
     * @param string $CustomText1
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomText1($CustomText1)
    {
      $this->CustomText1 = $CustomText1;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomText2()
    {
      return $this->CustomText2;
    }

    /**
     * @param string $CustomText2
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomText2($CustomText2)
    {
      $this->CustomText2 = $CustomText2;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomText3()
    {
      return $this->CustomText3;
    }

    /**
     * @param string $CustomText3
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomText3($CustomText3)
    {
      $this->CustomText3 = $CustomText3;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomText4()
    {
      return $this->CustomText4;
    }

    /**
     * @param string $CustomText4
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomText4($CustomText4)
    {
      $this->CustomText4 = $CustomText4;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomText5()
    {
      return $this->CustomText5;
    }

    /**
     * @param string $CustomText5
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomText5($CustomText5)
    {
      $this->CustomText5 = $CustomText5;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->CustomerId;
    }

    /**
     * @param int $CustomerId
     * @return \Opsuite\Customer\Customer
     */
    public function setCustomerId($CustomerId)
    {
      $this->CustomerId = $CustomerId;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateOfBirth()
    {
      if ($this->DateOfBirth == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateOfBirth);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateOfBirth
     * @return \Opsuite\Customer\Customer
     */
    public function setDateOfBirth(\DateTime $DateOfBirth = null)
    {
      if ($DateOfBirth == null) {
       $this->DateOfBirth = null;
      } else {
        $this->DateOfBirth = $DateOfBirth->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return \Opsuite\Customer\Customer
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

    /**
     * @return string
     */
    public function getFaxNumber()
    {
      return $this->FaxNumber;
    }

    /**
     * @param string $FaxNumber
     * @return \Opsuite\Customer\Customer
     */
    public function setFaxNumber($FaxNumber)
    {
      $this->FaxNumber = $FaxNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
      return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return \Opsuite\Customer\Customer
     */
    public function setFirstName($FirstName)
    {
      $this->FirstName = $FirstName;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsoCountryCode()
    {
      return $this->IsoCountryCode;
    }

    /**
     * @param string $IsoCountryCode
     * @return \Opsuite\Customer\Customer
     */
    public function setIsoCountryCode($IsoCountryCode)
    {
      $this->IsoCountryCode = $IsoCountryCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastClosingDate()
    {
      if ($this->LastClosingDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastClosingDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastClosingDate
     * @return \Opsuite\Customer\Customer
     */
    public function setLastClosingDate(\DateTime $LastClosingDate = null)
    {
      if ($LastClosingDate == null) {
       $this->LastClosingDate = null;
      } else {
        $this->LastClosingDate = $LastClosingDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
      return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return \Opsuite\Customer\Customer
     */
    public function setLastName($LastName)
    {
      $this->LastName = $LastName;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastStartingDate()
    {
      if ($this->LastStartingDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastStartingDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastStartingDate
     * @return \Opsuite\Customer\Customer
     */
    public function setLastStartingDate(\DateTime $LastStartingDate = null)
    {
      if ($LastStartingDate == null) {
       $this->LastStartingDate = null;
      } else {
        $this->LastStartingDate = $LastStartingDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Customer\Customer
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastVisit()
    {
      if ($this->LastVisit == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastVisit);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastVisit
     * @return \Opsuite\Customer\Customer
     */
    public function setLastVisit(\DateTime $LastVisit = null)
    {
      if ($LastVisit == null) {
       $this->LastVisit = null;
      } else {
        $this->LastVisit = $LastVisit->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationGroupId()
    {
      return $this->LocationGroupId;
    }

    /**
     * @param int $LocationGroupId
     * @return \Opsuite\Customer\Customer
     */
    public function setLocationGroupId($LocationGroupId)
    {
      $this->LocationGroupId = $LocationGroupId;
      return $this;
    }

    /**
     * @return string
     */
    public function getNotes()
    {
      return $this->Notes;
    }

    /**
     * @param string $Notes
     * @return \Opsuite\Customer\Customer
     */
    public function setNotes($Notes)
    {
      $this->Notes = $Notes;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getOptInDirectMail()
    {
      return $this->OptInDirectMail;
    }

    /**
     * @param boolean $OptInDirectMail
     * @return \Opsuite\Customer\Customer
     */
    public function setOptInDirectMail($OptInDirectMail)
    {
      $this->OptInDirectMail = $OptInDirectMail;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getOptInEmail()
    {
      return $this->OptInEmail;
    }

    /**
     * @param boolean $OptInEmail
     * @return \Opsuite\Customer\Customer
     */
    public function setOptInEmail($OptInEmail)
    {
      $this->OptInEmail = $OptInEmail;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getOptInTelephone()
    {
      return $this->OptInTelephone;
    }

    /**
     * @param boolean $OptInTelephone
     * @return \Opsuite\Customer\Customer
     */
    public function setOptInTelephone($OptInTelephone)
    {
      $this->OptInTelephone = $OptInTelephone;
      return $this;
    }

    /**
     * @return int
     */
    public function getOriginationLocationId()
    {
      return $this->OriginationLocationId;
    }

    /**
     * @param int $OriginationLocationId
     * @return \Opsuite\Customer\Customer
     */
    public function setOriginationLocationId($OriginationLocationId)
    {
      $this->OriginationLocationId = $OriginationLocationId;
      return $this;
    }

    /**
     * @return string
     */
    public function getReferredBy()
    {
      return $this->ReferredBy;
    }

    /**
     * @param string $ReferredBy
     * @return \Opsuite\Customer\Customer
     */
    public function setReferredBy($ReferredBy)
    {
      $this->ReferredBy = $ReferredBy;
      return $this;
    }

    /**
     * @return string
     */
    public function getSignedUpBy()
    {
      return $this->SignedUpBy;
    }

    /**
     * @param string $SignedUpBy
     * @return \Opsuite\Customer\Customer
     */
    public function setSignedUpBy($SignedUpBy)
    {
      $this->SignedUpBy = $SignedUpBy;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getTaxExempt()
    {
      return $this->TaxExempt;
    }

    /**
     * @param boolean $TaxExempt
     * @return \Opsuite\Customer\Customer
     */
    public function setTaxExempt($TaxExempt)
    {
      $this->TaxExempt = $TaxExempt;
      return $this;
    }

    /**
     * @return string
     */
    public function getTelephoneNumber()
    {
      return $this->TelephoneNumber;
    }

    /**
     * @param string $TelephoneNumber
     * @return \Opsuite\Customer\Customer
     */
    public function setTelephoneNumber($TelephoneNumber)
    {
      $this->TelephoneNumber = $TelephoneNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTerritory()
    {
      return $this->Territory;
    }

    /**
     * @param string $Territory
     * @return \Opsuite\Customer\Customer
     */
    public function setTerritory($Territory)
    {
      $this->Territory = $Territory;
      return $this;
    }

    /**
     * @return int
     */
    public function getTitleId()
    {
      return $this->TitleId;
    }

    /**
     * @param int $TitleId
     * @return \Opsuite\Customer\Customer
     */
    public function setTitleId($TitleId)
    {
      $this->TitleId = $TitleId;
      return $this;
    }

    /**
     * @return string
     */
    public function getZip()
    {
      return $this->Zip;
    }

    /**
     * @param string $Zip
     * @return \Opsuite\Customer\Customer
     */
    public function setZip($Zip)
    {
      $this->Zip = $Zip;
      return $this;
    }

}
