<?php

namespace Opsuite\Customer;

class Contact
{

    /**
     * @var string $AddressLine1
     */
    protected $AddressLine1 = null;

    /**
     * @var string $AddressLine2
     */
    protected $AddressLine2 = null;

    /**
     * @var string $AddressLine3
     */
    protected $AddressLine3 = null;

    /**
     * @var string $AddressLine4
     */
    protected $AddressLine4 = null;

    /**
     * @var string $City
     */
    protected $City = null;

    /**
     * @var string $Company
     */
    protected $Company = null;

    /**
     * @var int $ContactId
     */
    protected $ContactId = null;

    /**
     * @var ContactTypes $ContactType
     */
    protected $ContactType = null;

    /**
     * @var \DateTime $DateOfBirth
     */
    protected $DateOfBirth = null;

    /**
     * @var string $Email
     */
    protected $Email = null;

    /**
     * @var string $FaxNumber
     */
    protected $FaxNumber = null;

    /**
     * @var string $FirstName
     */
    protected $FirstName = null;

    /**
     * @var string $IsoCountryCode
     */
    protected $IsoCountryCode = null;

    /**
     * @var string $LastName
     */
    protected $LastName = null;

    /**
     * @var string $TelephoneNumber
     */
    protected $TelephoneNumber = null;

    /**
     * @var string $Territory
     */
    protected $Territory = null;

    /**
     * @var int $TitleId
     */
    protected $TitleId = null;

    /**
     * @var string $Zip
     */
    protected $Zip = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getAddressLine1()
    {
      return $this->AddressLine1;
    }

    /**
     * @param string $AddressLine1
     * @return \Opsuite\Customer\Contact
     */
    public function setAddressLine1($AddressLine1)
    {
      $this->AddressLine1 = $AddressLine1;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine2()
    {
      return $this->AddressLine2;
    }

    /**
     * @param string $AddressLine2
     * @return \Opsuite\Customer\Contact
     */
    public function setAddressLine2($AddressLine2)
    {
      $this->AddressLine2 = $AddressLine2;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine3()
    {
      return $this->AddressLine3;
    }

    /**
     * @param string $AddressLine3
     * @return \Opsuite\Customer\Contact
     */
    public function setAddressLine3($AddressLine3)
    {
      $this->AddressLine3 = $AddressLine3;
      return $this;
    }

    /**
     * @return string
     */
    public function getAddressLine4()
    {
      return $this->AddressLine4;
    }

    /**
     * @param string $AddressLine4
     * @return \Opsuite\Customer\Contact
     */
    public function setAddressLine4($AddressLine4)
    {
      $this->AddressLine4 = $AddressLine4;
      return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
      return $this->City;
    }

    /**
     * @param string $City
     * @return \Opsuite\Customer\Contact
     */
    public function setCity($City)
    {
      $this->City = $City;
      return $this;
    }

    /**
     * @return string
     */
    public function getCompany()
    {
      return $this->Company;
    }

    /**
     * @param string $Company
     * @return \Opsuite\Customer\Contact
     */
    public function setCompany($Company)
    {
      $this->Company = $Company;
      return $this;
    }

    /**
     * @return int
     */
    public function getContactId()
    {
      return $this->ContactId;
    }

    /**
     * @param int $ContactId
     * @return \Opsuite\Customer\Contact
     */
    public function setContactId($ContactId)
    {
      $this->ContactId = $ContactId;
      return $this;
    }

    /**
     * @return ContactTypes
     */
    public function getContactType()
    {
      return $this->ContactType;
    }

    /**
     * @param ContactTypes $ContactType
     * @return \Opsuite\Customer\Contact
     */
    public function setContactType($ContactType)
    {
      $this->ContactType = $ContactType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateOfBirth()
    {
      if ($this->DateOfBirth == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateOfBirth);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateOfBirth
     * @return \Opsuite\Customer\Contact
     */
    public function setDateOfBirth(\DateTime $DateOfBirth = null)
    {
      if ($DateOfBirth == null) {
       $this->DateOfBirth = null;
      } else {
        $this->DateOfBirth = $DateOfBirth->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
      return $this->Email;
    }

    /**
     * @param string $Email
     * @return \Opsuite\Customer\Contact
     */
    public function setEmail($Email)
    {
      $this->Email = $Email;
      return $this;
    }

    /**
     * @return string
     */
    public function getFaxNumber()
    {
      return $this->FaxNumber;
    }

    /**
     * @param string $FaxNumber
     * @return \Opsuite\Customer\Contact
     */
    public function setFaxNumber($FaxNumber)
    {
      $this->FaxNumber = $FaxNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
      return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return \Opsuite\Customer\Contact
     */
    public function setFirstName($FirstName)
    {
      $this->FirstName = $FirstName;
      return $this;
    }

    /**
     * @return string
     */
    public function getIsoCountryCode()
    {
      return $this->IsoCountryCode;
    }

    /**
     * @param string $IsoCountryCode
     * @return \Opsuite\Customer\Contact
     */
    public function setIsoCountryCode($IsoCountryCode)
    {
      $this->IsoCountryCode = $IsoCountryCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
      return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return \Opsuite\Customer\Contact
     */
    public function setLastName($LastName)
    {
      $this->LastName = $LastName;
      return $this;
    }

    /**
     * @return string
     */
    public function getTelephoneNumber()
    {
      return $this->TelephoneNumber;
    }

    /**
     * @param string $TelephoneNumber
     * @return \Opsuite\Customer\Contact
     */
    public function setTelephoneNumber($TelephoneNumber)
    {
      $this->TelephoneNumber = $TelephoneNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getTerritory()
    {
      return $this->Territory;
    }

    /**
     * @param string $Territory
     * @return \Opsuite\Customer\Contact
     */
    public function setTerritory($Territory)
    {
      $this->Territory = $Territory;
      return $this;
    }

    /**
     * @return int
     */
    public function getTitleId()
    {
      return $this->TitleId;
    }

    /**
     * @param int $TitleId
     * @return \Opsuite\Customer\Contact
     */
    public function setTitleId($TitleId)
    {
      $this->TitleId = $TitleId;
      return $this;
    }

    /**
     * @return string
     */
    public function getZip()
    {
      return $this->Zip;
    }

    /**
     * @param string $Zip
     * @return \Opsuite\Customer\Contact
     */
    public function setZip($Zip)
    {
      $this->Zip = $Zip;
      return $this;
    }

}
