<?php

namespace Opsuite\Customer;

class ArrayOfMultiStoreOrderLine implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var MultiStoreOrderLine[] $MultiStoreOrderLine
     */
    protected $MultiStoreOrderLine = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return MultiStoreOrderLine[]
     */
    public function getMultiStoreOrderLine()
    {
      return $this->MultiStoreOrderLine;
    }

    /**
     * @param MultiStoreOrderLine[] $MultiStoreOrderLine
     * @return \Opsuite\Customer\ArrayOfMultiStoreOrderLine
     */
    public function setMultiStoreOrderLine(array $MultiStoreOrderLine = null)
    {
      $this->MultiStoreOrderLine = $MultiStoreOrderLine;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->MultiStoreOrderLine[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return MultiStoreOrderLine
     */
    public function offsetGet($offset)
    {
      return $this->MultiStoreOrderLine[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param MultiStoreOrderLine $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->MultiStoreOrderLine[] = $value;
      } else {
        $this->MultiStoreOrderLine[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->MultiStoreOrderLine[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return MultiStoreOrderLine Return the current element
     */
    public function current()
    {
      return current($this->MultiStoreOrderLine);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->MultiStoreOrderLine);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->MultiStoreOrderLine);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->MultiStoreOrderLine);
    }

    /**
     * Countable implementation
     *
     * @return MultiStoreOrderLine Return count of elements
     */
    public function count()
    {
      return count($this->MultiStoreOrderLine);
    }

}
