<?php

namespace Opsuite\Customer;

class ArrayOfAccountReceivable implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AccountReceivable[] $AccountReceivable
     */
    protected $AccountReceivable = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AccountReceivable[]
     */
    public function getAccountReceivable()
    {
      return $this->AccountReceivable;
    }

    /**
     * @param AccountReceivable[] $AccountReceivable
     * @return \Opsuite\Customer\ArrayOfAccountReceivable
     */
    public function setAccountReceivable(array $AccountReceivable = null)
    {
      $this->AccountReceivable = $AccountReceivable;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AccountReceivable[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AccountReceivable
     */
    public function offsetGet($offset)
    {
      return $this->AccountReceivable[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AccountReceivable $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AccountReceivable[] = $value;
      } else {
        $this->AccountReceivable[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AccountReceivable[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AccountReceivable Return the current element
     */
    public function current()
    {
      return current($this->AccountReceivable);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AccountReceivable);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AccountReceivable);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AccountReceivable);
    }

    /**
     * Countable implementation
     *
     * @return AccountReceivable Return count of elements
     */
    public function count()
    {
      return count($this->AccountReceivable);
    }

}
