<?php

namespace Opsuite\Customer;

class AddTransactionToCustomer
{

    /**
     * @var int $customerId
     */
    protected $customerId = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var int $externalTransactionNumber
     */
    protected $externalTransactionNumber = null;

    /**
     * @param int $customerId
     * @param int $locationId
     * @param int $externalTransactionNumber
     */
    public function __construct($customerId, $locationId, $externalTransactionNumber)
    {
      $this->customerId = $customerId;
      $this->locationId = $locationId;
      $this->externalTransactionNumber = $externalTransactionNumber;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->customerId;
    }

    /**
     * @param int $customerId
     * @return \Opsuite\Customer\AddTransactionToCustomer
     */
    public function setCustomerId($customerId)
    {
      $this->customerId = $customerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\Customer\AddTransactionToCustomer
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalTransactionNumber()
    {
      return $this->externalTransactionNumber;
    }

    /**
     * @param int $externalTransactionNumber
     * @return \Opsuite\Customer\AddTransactionToCustomer
     */
    public function setExternalTransactionNumber($externalTransactionNumber)
    {
      $this->externalTransactionNumber = $externalTransactionNumber;
      return $this;
    }

}
