<?php

namespace Opsuite\Customer;

class AddLoyaltyTransaction
{

    /**
     * @var int $storeId
     */
    protected $storeId = null;

    /**
     * @var int $customerId
     */
    protected $customerId = null;

    /**
     * @var int $transactionId
     */
    protected $transactionId = null;

    /**
     * @var int $loyaltyTransactionId
     */
    protected $loyaltyTransactionId = null;

    /**
     * @var int $loyaltyPoints
     */
    protected $loyaltyPoints = null;

    /**
     * @var \DateTime $expiryDate
     */
    protected $expiryDate = null;

    /**
     * @var int $reasonCodeId
     */
    protected $reasonCodeId = null;

    /**
     * @param int $storeId
     * @param int $customerId
     * @param int $transactionId
     * @param int $loyaltyTransactionId
     * @param int $loyaltyPoints
     * @param \DateTime $expiryDate
     * @param int $reasonCodeId
     */
    public function __construct($storeId, $customerId, $transactionId, $loyaltyTransactionId, $loyaltyPoints, \DateTime $expiryDate, $reasonCodeId)
    {
      $this->storeId = $storeId;
      $this->customerId = $customerId;
      $this->transactionId = $transactionId;
      $this->loyaltyTransactionId = $loyaltyTransactionId;
      $this->loyaltyPoints = $loyaltyPoints;
      $this->expiryDate = $expiryDate->format(\DateTime::ATOM);
      $this->reasonCodeId = $reasonCodeId;
    }

    /**
     * @return int
     */
    public function getStoreId()
    {
      return $this->storeId;
    }

    /**
     * @param int $storeId
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setStoreId($storeId)
    {
      $this->storeId = $storeId;
      return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
      return $this->customerId;
    }

    /**
     * @param int $customerId
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setCustomerId($customerId)
    {
      $this->customerId = $customerId;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransactionId()
    {
      return $this->transactionId;
    }

    /**
     * @param int $transactionId
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setTransactionId($transactionId)
    {
      $this->transactionId = $transactionId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLoyaltyTransactionId()
    {
      return $this->loyaltyTransactionId;
    }

    /**
     * @param int $loyaltyTransactionId
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setLoyaltyTransactionId($loyaltyTransactionId)
    {
      $this->loyaltyTransactionId = $loyaltyTransactionId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLoyaltyPoints()
    {
      return $this->loyaltyPoints;
    }

    /**
     * @param int $loyaltyPoints
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setLoyaltyPoints($loyaltyPoints)
    {
      $this->loyaltyPoints = $loyaltyPoints;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpiryDate()
    {
      if ($this->expiryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->expiryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $expiryDate
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setExpiryDate(\DateTime $expiryDate)
    {
      $this->expiryDate = $expiryDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getReasonCodeId()
    {
      return $this->reasonCodeId;
    }

    /**
     * @param int $reasonCodeId
     * @return \Opsuite\Customer\AddLoyaltyTransaction
     */
    public function setReasonCodeId($reasonCodeId)
    {
      $this->reasonCodeId = $reasonCodeId;
      return $this;
    }

}
