<?php

namespace Opsuite\Customer;

class AccountReceivableHistory
{

    /**
     * @var int $AccountReceivableId
     */
    protected $AccountReceivableId = null;

    /**
     * @var boolean $Allocate
     */
    protected $Allocate = null;

    /**
     * @var int $CashierId
     */
    protected $CashierId = null;

    /**
     * @var float $CreditAmount
     */
    protected $CreditAmount = null;

    /**
     * @var \DateTime $DateCreated
     */
    protected $DateCreated = null;

    /**
     * @var float $DebitAmount
     */
    protected $DebitAmount = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return int
     */
    public function getAccountReceivableId()
    {
      return $this->AccountReceivableId;
    }

    /**
     * @param int $AccountReceivableId
     * @return \Opsuite\Customer\AccountReceivableHistory
     */
    public function setAccountReceivableId($AccountReceivableId)
    {
      $this->AccountReceivableId = $AccountReceivableId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getAllocate()
    {
      return $this->Allocate;
    }

    /**
     * @param boolean $Allocate
     * @return \Opsuite\Customer\AccountReceivableHistory
     */
    public function setAllocate($Allocate)
    {
      $this->Allocate = $Allocate;
      return $this;
    }

    /**
     * @return int
     */
    public function getCashierId()
    {
      return $this->CashierId;
    }

    /**
     * @param int $CashierId
     * @return \Opsuite\Customer\AccountReceivableHistory
     */
    public function setCashierId($CashierId)
    {
      $this->CashierId = $CashierId;
      return $this;
    }

    /**
     * @return float
     */
    public function getCreditAmount()
    {
      return $this->CreditAmount;
    }

    /**
     * @param float $CreditAmount
     * @return \Opsuite\Customer\AccountReceivableHistory
     */
    public function setCreditAmount($CreditAmount)
    {
      $this->CreditAmount = $CreditAmount;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
      if ($this->DateCreated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateCreated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateCreated
     * @return \Opsuite\Customer\AccountReceivableHistory
     */
    public function setDateCreated(\DateTime $DateCreated = null)
    {
      if ($DateCreated == null) {
       $this->DateCreated = null;
      } else {
        $this->DateCreated = $DateCreated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getDebitAmount()
    {
      return $this->DebitAmount;
    }

    /**
     * @param float $DebitAmount
     * @return \Opsuite\Customer\AccountReceivableHistory
     */
    public function setDebitAmount($DebitAmount)
    {
      $this->DebitAmount = $DebitAmount;
      return $this;
    }

}
