<?php

namespace Opsuite\Customer;

class AccountReceivable
{

    /**
     * @var string $AccountNumber
     */
    protected $AccountNumber = null;

    /**
     * @var int $AccountReceivableId
     */
    protected $AccountReceivableId = null;

    /**
     * @var float $Balance
     */
    protected $Balance = null;

    /**
     * @var \DateTime $DateCreated
     */
    protected $DateCreated = null;

    /**
     * @var \DateTime $DateDue
     */
    protected $DateDue = null;

    /**
     * @var int $ExternalAccountReceivableId
     */
    protected $ExternalAccountReceivableId = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    /**
     * @var string $LocationName
     */
    protected $LocationName = null;

    /**
     * @var int $Locationid
     */
    protected $Locationid = null;

    /**
     * @var float $OriginalAmount
     */
    protected $OriginalAmount = null;

    /**
     * @var boolean $Pay
     */
    protected $Pay = null;

    /**
     * @var float $Payment
     */
    protected $Payment = null;

    /**
     * @var string $TransactionId
     */
    protected $TransactionId = null;

    /**
     * @var string $Type
     */
    protected $Type = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return string
     */
    public function getAccountNumber()
    {
      return $this->AccountNumber;
    }

    /**
     * @param string $AccountNumber
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setAccountNumber($AccountNumber)
    {
      $this->AccountNumber = $AccountNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getAccountReceivableId()
    {
      return $this->AccountReceivableId;
    }

    /**
     * @param int $AccountReceivableId
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setAccountReceivableId($AccountReceivableId)
    {
      $this->AccountReceivableId = $AccountReceivableId;
      return $this;
    }

    /**
     * @return float
     */
    public function getBalance()
    {
      return $this->Balance;
    }

    /**
     * @param float $Balance
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setBalance($Balance)
    {
      $this->Balance = $Balance;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
      if ($this->DateCreated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateCreated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateCreated
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setDateCreated(\DateTime $DateCreated = null)
    {
      if ($DateCreated == null) {
       $this->DateCreated = null;
      } else {
        $this->DateCreated = $DateCreated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateDue()
    {
      if ($this->DateDue == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->DateDue);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $DateDue
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setDateDue(\DateTime $DateDue = null)
    {
      if ($DateDue == null) {
       $this->DateDue = null;
      } else {
        $this->DateDue = $DateDue->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalAccountReceivableId()
    {
      return $this->ExternalAccountReceivableId;
    }

    /**
     * @param int $ExternalAccountReceivableId
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setExternalAccountReceivableId($ExternalAccountReceivableId)
    {
      $this->ExternalAccountReceivableId = $ExternalAccountReceivableId;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationName()
    {
      return $this->LocationName;
    }

    /**
     * @param string $LocationName
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setLocationName($LocationName)
    {
      $this->LocationName = $LocationName;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationid()
    {
      return $this->Locationid;
    }

    /**
     * @param int $Locationid
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setLocationid($Locationid)
    {
      $this->Locationid = $Locationid;
      return $this;
    }

    /**
     * @return float
     */
    public function getOriginalAmount()
    {
      return $this->OriginalAmount;
    }

    /**
     * @param float $OriginalAmount
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setOriginalAmount($OriginalAmount)
    {
      $this->OriginalAmount = $OriginalAmount;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getPay()
    {
      return $this->Pay;
    }

    /**
     * @param boolean $Pay
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setPay($Pay)
    {
      $this->Pay = $Pay;
      return $this;
    }

    /**
     * @return float
     */
    public function getPayment()
    {
      return $this->Payment;
    }

    /**
     * @param float $Payment
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setPayment($Payment)
    {
      $this->Payment = $Payment;
      return $this;
    }

    /**
     * @return string
     */
    public function getTransactionId()
    {
      return $this->TransactionId;
    }

    /**
     * @param string $TransactionId
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setTransactionId($TransactionId)
    {
      $this->TransactionId = $TransactionId;
      return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
      return $this->Type;
    }

    /**
     * @param string $Type
     * @return \Opsuite\Customer\AccountReceivable
     */
    public function setType($Type)
    {
      $this->Type = $Type;
      return $this;
    }

}
