<?php

namespace Opsuite\Company;

class LocationGroup
{

    /**
     * @var boolean $Active
     */
    protected $Active = null;

    /**
     * @var string $DefaultCurrencyCode
     */
    protected $DefaultCurrencyCode = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $GroupCode
     */
    protected $GroupCode = null;

    /**
     * @var \DateTime $LastUpdated
     */
    protected $LastUpdated = null;

    /**
     * @var int $LocationGroupId
     */
    protected $LocationGroupId = null;

    /**
     * @var string $Name
     */
    protected $Name = null;

    /**
     * @var int $ParentLocationGroupId
     */
    protected $ParentLocationGroupId = null;

    /**
     * @var int $Tier
     */
    protected $Tier = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
      return $this->Active;
    }

    /**
     * @param boolean $Active
     * @return \Opsuite\Company\LocationGroup
     */
    public function setActive($Active)
    {
      $this->Active = $Active;
      return $this;
    }

    /**
     * @return string
     */
    public function getDefaultCurrencyCode()
    {
      return $this->DefaultCurrencyCode;
    }

    /**
     * @param string $DefaultCurrencyCode
     * @return \Opsuite\Company\LocationGroup
     */
    public function setDefaultCurrencyCode($DefaultCurrencyCode)
    {
      $this->DefaultCurrencyCode = $DefaultCurrencyCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\Company\LocationGroup
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getGroupCode()
    {
      return $this->GroupCode;
    }

    /**
     * @param string $GroupCode
     * @return \Opsuite\Company\LocationGroup
     */
    public function setGroupCode($GroupCode)
    {
      $this->GroupCode = $GroupCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdated()
    {
      if ($this->LastUpdated == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->LastUpdated);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $LastUpdated
     * @return \Opsuite\Company\LocationGroup
     */
    public function setLastUpdated(\DateTime $LastUpdated = null)
    {
      if ($LastUpdated == null) {
       $this->LastUpdated = null;
      } else {
        $this->LastUpdated = $LastUpdated->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationGroupId()
    {
      return $this->LocationGroupId;
    }

    /**
     * @param int $LocationGroupId
     * @return \Opsuite\Company\LocationGroup
     */
    public function setLocationGroupId($LocationGroupId)
    {
      $this->LocationGroupId = $LocationGroupId;
      return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
      return $this->Name;
    }

    /**
     * @param string $Name
     * @return \Opsuite\Company\LocationGroup
     */
    public function setName($Name)
    {
      $this->Name = $Name;
      return $this;
    }

    /**
     * @return int
     */
    public function getParentLocationGroupId()
    {
      return $this->ParentLocationGroupId;
    }

    /**
     * @param int $ParentLocationGroupId
     * @return \Opsuite\Company\LocationGroup
     */
    public function setParentLocationGroupId($ParentLocationGroupId)
    {
      $this->ParentLocationGroupId = $ParentLocationGroupId;
      return $this;
    }

    /**
     * @return int
     */
    public function getTier()
    {
      return $this->Tier;
    }

    /**
     * @param int $Tier
     * @return \Opsuite\Company\LocationGroup
     */
    public function setTier($Tier)
    {
      $this->Tier = $Tier;
      return $this;
    }

}
