<?php

namespace Opsuite\Company;

use Opsuite\WSSSoapClient;

class CompanyService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfLocation' => 'Opsuite\\Company\\ArrayOfLocation',
      'Location' => 'Opsuite\\Company\\Location',
      'ArrayOfLocationGroup' => 'Opsuite\\Company\\ArrayOfLocationGroup',
      'LocationGroup' => 'Opsuite\\Company\\LocationGroup',
      'ArrayOfIsoCountry' => 'Opsuite\\Company\\ArrayOfIsoCountry',
      'IsoCountry' => 'Opsuite\\Company\\IsoCountry',
      'ArrayOfTitle' => 'Opsuite\\Company\\ArrayOfTitle',
      'Title' => 'Opsuite\\Company\\Title',
      'ArrayOfint' => 'Opsuite\\Company\\ArrayOfint',
      'ArrayOfstring' => 'Opsuite\\Company\\ArrayOfstring',
      'GetLocations' => 'Opsuite\\Company\\GetLocations',
      'GetLocationsResponse' => 'Opsuite\\Company\\GetLocationsResponse',
      'GetLocationGroups' => 'Opsuite\\Company\\GetLocationGroups',
      'GetLocationGroupsResponse' => 'Opsuite\\Company\\GetLocationGroupsResponse',
      'GetIsoCountries' => 'Opsuite\\Company\\GetIsoCountries',
      'GetIsoCountriesResponse' => 'Opsuite\\Company\\GetIsoCountriesResponse',
      'GetTitles' => 'Opsuite\\Company\\GetTitles',
      'GetTitlesResponse' => 'Opsuite\\Company\\GetTitlesResponse',
      'GetLocationById' => 'Opsuite\\Company\\GetLocationById',
      'GetLocationByIdResponse' => 'Opsuite\\Company\\GetLocationByIdResponse',
      'GetLocationsByIds' => 'Opsuite\\Company\\GetLocationsByIds',
      'GetLocationsByIdsResponse' => 'Opsuite\\Company\\GetLocationsByIdsResponse',
      'GetLocationByCode' => 'Opsuite\\Company\\GetLocationByCode',
      'GetLocationByCodeResponse' => 'Opsuite\\Company\\GetLocationByCodeResponse',
      'GetLocationsByCodes' => 'Opsuite\\Company\\GetLocationsByCodes',
      'GetLocationsByCodesResponse' => 'Opsuite\\Company\\GetLocationsByCodesResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/CompanyService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetLocations $parameters
     * @return GetLocationsResponse
     */
    public function GetLocations(GetLocations $parameters)
    {
      return $this->__soapCall('GetLocations', array($parameters));
    }

    /**
     * @param GetLocationGroups $parameters
     * @return GetLocationGroupsResponse
     */
    public function GetLocationGroups(GetLocationGroups $parameters)
    {
      return $this->__soapCall('GetLocationGroups', array($parameters));
    }

    /**
     * @param GetIsoCountries $parameters
     * @return GetIsoCountriesResponse
     */
    public function GetIsoCountries(GetIsoCountries $parameters)
    {
      return $this->__soapCall('GetIsoCountries', array($parameters));
    }

    /**
     * @param GetTitles $parameters
     * @return GetTitlesResponse
     */
    public function GetTitles(GetTitles $parameters)
    {
      return $this->__soapCall('GetTitles', array($parameters));
    }

    /**
     * @param GetLocationById $parameters
     * @return GetLocationByIdResponse
     */
    public function GetLocationById(GetLocationById $parameters)
    {
      return $this->__soapCall('GetLocationById', array($parameters));
    }

    /**
     * @param GetLocationsByIds $parameters
     * @return GetLocationsByIdsResponse
     */
    public function GetLocationsByIds(GetLocationsByIds $parameters)
    {
      return $this->__soapCall('GetLocationsByIds', array($parameters));
    }

    /**
     * @param GetLocationByCode $parameters
     * @return GetLocationByCodeResponse
     */
    public function GetLocationByCode(GetLocationByCode $parameters)
    {
      return $this->__soapCall('GetLocationByCode', array($parameters));
    }

    /**
     * @param GetLocationsByCodes $parameters
     * @return GetLocationsByCodesResponse
     */
    public function GetLocationsByCodes(GetLocationsByCodes $parameters)
    {
      return $this->__soapCall('GetLocationsByCodes', array($parameters));
    }

}
