<?php

namespace Opsuite\Company;

class ArrayOfTitle implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Title[] $Title
     */
    protected $Title = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Title[]
     */
    public function getTitle()
    {
      return $this->Title;
    }

    /**
     * @param Title[] $Title
     * @return \Opsuite\Company\ArrayOfTitle
     */
    public function setTitle(array $Title = null)
    {
      $this->Title = $Title;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Title[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Title
     */
    public function offsetGet($offset)
    {
      return $this->Title[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Title $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Title[] = $value;
      } else {
        $this->Title[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Title[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Title Return the current element
     */
    public function current()
    {
      return current($this->Title);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Title);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Title);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Title);
    }

    /**
     * Countable implementation
     *
     * @return Title Return count of elements
     */
    public function count()
    {
      return count($this->Title);
    }

}
