<?php

namespace Opsuite\Company;

class ArrayOfIsoCountry implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var IsoCountry[] $IsoCountry
     */
    protected $IsoCountry = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return IsoCountry[]
     */
    public function getIsoCountry()
    {
      return $this->IsoCountry;
    }

    /**
     * @param IsoCountry[] $IsoCountry
     * @return \Opsuite\Company\ArrayOfIsoCountry
     */
    public function setIsoCountry(array $IsoCountry = null)
    {
      $this->IsoCountry = $IsoCountry;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->IsoCountry[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return IsoCountry
     */
    public function offsetGet($offset)
    {
      return $this->IsoCountry[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param IsoCountry $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->IsoCountry[] = $value;
      } else {
        $this->IsoCountry[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->IsoCountry[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return IsoCountry Return the current element
     */
    public function current()
    {
      return current($this->IsoCountry);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->IsoCountry);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->IsoCountry);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->IsoCountry);
    }

    /**
     * Countable implementation
     *
     * @return IsoCountry Return count of elements
     */
    public function count()
    {
      return count($this->IsoCountry);
    }

}
