<?php

namespace Opsuite\BatchExport;

class GLExportByLocationIdAndBatchStatus
{

    /**
     * @var ExportType $exportType
     */
    protected $exportType = null;

    /**
     * @var int $locationId
     */
    protected $locationId = null;

    /**
     * @var BatchStatus $status
     */
    protected $status = null;

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var int $lastBatchNumber
     */
    protected $lastBatchNumber = null;

    /**
     * @param ExportType $exportType
     * @param int $locationId
     * @param BatchStatus $status
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param int $lastBatchNumber
     */
    public function __construct($exportType, $locationId, $status, \DateTime $startDate, \DateTime $endDate, $lastBatchNumber)
    {
      $this->exportType = $exportType;
      $this->locationId = $locationId;
      $this->status = $status;
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->lastBatchNumber = $lastBatchNumber;
    }

    /**
     * @return ExportType
     */
    public function getExportType()
    {
      return $this->exportType;
    }

    /**
     * @param ExportType $exportType
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchStatus
     */
    public function setExportType($exportType)
    {
      $this->exportType = $exportType;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->locationId;
    }

    /**
     * @param int $locationId
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchStatus
     */
    public function setLocationId($locationId)
    {
      $this->locationId = $locationId;
      return $this;
    }

    /**
     * @return BatchStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param BatchStatus $status
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchStatus
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchStatus
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchStatus
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getLastBatchNumber()
    {
      return $this->lastBatchNumber;
    }

    /**
     * @param int $lastBatchNumber
     * @return \Opsuite\BatchExport\GLExportByLocationIdAndBatchStatus
     */
    public function setLastBatchNumber($lastBatchNumber)
    {
      $this->lastBatchNumber = $lastBatchNumber;
      return $this;
    }

}
